"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RetentionColumn = RetentionColumn;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _indexLifecycleManagementCommonShared = require("@kbn/index-lifecycle-management-common-shared");
var _streamsSchema = require("@kbn/streams-schema");
var _use_kibana = require("../../hooks/use_kibana");
var _translations = require("./translations");
var _format_size_units = require("../data_management/stream_detail_lifecycle/helpers/format_size_units");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/stream_list_view/retention_column.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function RetentionColumn({
  lifecycle,
  dataTestSubj
}) {
  const {
    dependencies: {
      start: {
        share
      }
    }
  } = (0, _use_kibana.useKibana)();
  const ilmLocator = share.url.locators.get(_indexLifecycleManagementCommonShared.ILM_LOCATOR_ID);
  if ((0, _streamsSchema.isErrorLifecycle)(lifecycle)) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow",
      "aria-label": _i18n.i18n.translate('xpack.streams.streamsRetentionColumn.errorBadgeAriaLabel', {
        defaultMessage: 'Retention policy error: {message}',
        values: {
          message: lifecycle.error.message
        }
      }),
      role: "status",
      "aria-live": "polite",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 40,
        columnNumber: 7
      }
    }, lifecycle.error.message);
  }
  if ((0, _streamsSchema.isIlmLifecycle)(lifecycle)) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 56,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: ilmLocator === null || ilmLocator === void 0 ? void 0 : ilmLocator.getRedirectUrl({
        page: 'policy_edit',
        policyName: lifecycle.ilm.policy
      }),
      target: "_blank",
      "aria-label": _i18n.i18n.translate('xpack.streams.streamsRetentionColumn.ilmLinkAriaLabel', {
        defaultMessage: 'ILM policy: {name}, click to edit the policy in a new tab',
        values: {
          name: lifecycle.ilm.policy
        }
      }),
      css: {
        whiteSpace: 'nowrap',
        textOverflow: 'ellipsis',
        overflow: 'hidden',
        maxWidth: '150px'
      },
      "data-test-subj": dataTestSubj,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 57,
        columnNumber: 9
      }
    }, lifecycle.ilm.policy), /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "hollow",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 77,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 78,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.streams.streamsRetentionColumn.ilmBadgeLabel', {
      defaultMessage: 'ILM'
    }))));
  }
  if ((0, _streamsSchema.isDslLifecycle)(lifecycle)) {
    const retentionValue = (0, _format_size_units.getTimeSizeAndUnitLabel)(lifecycle.dsl.data_retention);
    if (retentionValue) {
      return /*#__PURE__*/_react.default.createElement("span", {
        tabIndex: 0,
        "aria-label": _i18n.i18n.translate('xpack.streams.streamsRetentionColumn.dslRetentionAriaLabel', {
          defaultMessage: 'Data retention period: {retention}',
          values: {
            retention: retentionValue
          }
        }),
        "data-test-subj": dataTestSubj,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 92,
          columnNumber: 9
        }
      }, retentionValue);
    }
    return /*#__PURE__*/_react.default.createElement("span", {
      tabIndex: 0,
      "aria-label": _translations.INDEFINITE_RETENTION_ARIA_LABEL,
      "data-test-subj": dataTestSubj,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 106,
        columnNumber: 7
      }
    }, _translations.INDEFINITE_RETENTION_LABEL);
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    tabIndex: 0,
    "aria-label": _translations.NO_RETENTION_LABEL,
    "data-test-subj": dataTestSubj,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 5
    }
  }, _translations.NO_DATA_SHORT_LABEL);
}