"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataQualityColumn = DataQualityColumn;
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/dataset-quality-plugin/public");
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
var _eui = require("@elastic/eui");
var _esql_result_to_timeseries = require("../../util/esql_result_to_timeseries");
var _calculate_data_quality = require("../../util/calculate_data_quality");
var _use_streams_app_router = require("../../hooks/use_streams_app_router");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/stream_list_view/data_quality_column.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function DataQualityColumn({
  histogramQueryFetch,
  streamName
}) {
  var _degradedDocsResult$v, _degradedDocsResult$v2, _degradedDocsResult$v3, _failedDocsResult$val, _failedDocsResult$val2, _failedDocsResult$val3;
  const histogramQueryResult = (0, _useAsync.default)(() => histogramQueryFetch.docCount, [histogramQueryFetch]);
  const failedDocsResult = (0, _useAsync.default)(() => histogramQueryFetch.failedDocCount, [histogramQueryFetch]);
  const degradedDocsResult = (0, _useAsync.default)(() => histogramQueryFetch.degradedDocCount, [histogramQueryFetch]);
  const allTimeseries = _react.default.useMemo(() => (0, _esql_result_to_timeseries.esqlResultToTimeseries)({
    result: histogramQueryResult,
    metricNames: ['doc_count']
  }), [histogramQueryResult]);
  const docCount = _react.default.useMemo(() => allTimeseries.reduce((acc, series) => acc + series.data.reduce((acc2, item) => acc2 + (item.doc_count || 0), 0), 0), [allTimeseries]);
  const degradedDocCount = degradedDocsResult !== null && degradedDocsResult !== void 0 && degradedDocsResult.value ? Number((_degradedDocsResult$v = degradedDocsResult.value) === null || _degradedDocsResult$v === void 0 ? void 0 : (_degradedDocsResult$v2 = _degradedDocsResult$v.values) === null || _degradedDocsResult$v2 === void 0 ? void 0 : (_degradedDocsResult$v3 = _degradedDocsResult$v2[0]) === null || _degradedDocsResult$v3 === void 0 ? void 0 : _degradedDocsResult$v3[0]) : 0;
  const failedDocCount = failedDocsResult !== null && failedDocsResult !== void 0 && failedDocsResult.value ? Number((_failedDocsResult$val = failedDocsResult.value) === null || _failedDocsResult$val === void 0 ? void 0 : (_failedDocsResult$val2 = _failedDocsResult$val.values) === null || _failedDocsResult$val2 === void 0 ? void 0 : (_failedDocsResult$val3 = _failedDocsResult$val2[0]) === null || _failedDocsResult$val3 === void 0 ? void 0 : _failedDocsResult$val3[0]) : 0;
  const quality = (0, _calculate_data_quality.calculateDataQuality)({
    totalDocs: docCount,
    degradedDocs: degradedDocCount,
    failedDocs: failedDocCount
  });
  const isLoading = histogramQueryResult.loading || (failedDocsResult === null || failedDocsResult === void 0 ? void 0 : failedDocsResult.loading) || degradedDocsResult.loading;
  const router = (0, _use_streams_app_router.useStreamsAppRouter)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: router.link('/{key}/management/{tab}', {
      path: {
        key: streamName,
        tab: 'dataQuality'
      }
    }),
    "data-test-subj": `streamsDataQualityLink-${streamName}`,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_public.DatasetQualityIndicator, {
    dataTestSubj: `dataQualityIndicator-${streamName}`,
    quality: quality,
    isLoading: isLoading,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 7
    }
  }));
}