"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SignificantEventsTable = SignificantEventsTable;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _constants = require("@kbn/deeplinks-analytics/constants");
var _stream_feature_details_flyout = require("../stream_detail_features/stream_features/stream_feature_details_flyout");
var _use_kibana = require("../../hooks/use_kibana");
var _change_point = require("./utils/change_point");
var _significant_events_histogram = require("./significant_events_histogram");
var _discover_helpers = require("./utils/discover_helpers");
var _use_timefilter = require("../../hooks/use_timefilter");
var _use_stream_features = require("../stream_detail_features/stream_features/hooks/use_stream_features");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/stream_detail_significant_events_view/significant_events_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function SignificantEventsTable({
  definition,
  items,
  onDeleteClick,
  onEditClick,
  xFormatter,
  loading
}) {
  const {
    share
  } = (0, _use_kibana.useKibana)().dependencies.start;
  const {
    timeState
  } = (0, _use_timefilter.useTimefilter)();
  const [isDeleteModalVisible, setIsDeleteModalVisible] = (0, _react.useState)(false);
  const [selectedDeleteItem, setSelectedDeleteItem] = (0, _react.useState)();
  const [isDeleteLoading, setIsDeleteLoading] = (0, _react.useState)(false);
  const [selectedFeature, setSelectedFeature] = (0, _react.useState)();
  const {
    featuresByName,
    refreshFeatures
  } = (0, _use_stream_features.useStreamFeatures)(definition);
  const discoverLocator = share.url.locators.get(_constants.DISCOVER_APP_LOCATOR);
  const columns = [{
    field: 'title',
    name: _i18n.i18n.translate('xpack.streams.significantEventsTable.titleColumnTitle', {
      defaultMessage: 'Title'
    }),
    render: (_, record) => discoverLocator ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "aria-label": _i18n.i18n.translate('xpack.streams.columns.euiButtonEmpty.openInDiscoverLabel', {
        defaultMessage: 'Open in discover'
      }),
      href: discoverLocator.getRedirectUrl((0, _discover_helpers.buildDiscoverParams)(record.query, definition, timeState)),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 62,
        columnNumber: 11
      }
    }, record.query.title) : record.query.title
  }, {
    field: 'query',
    name: _i18n.i18n.translate('xpack.streams.significantEventsTable.feature', {
      defaultMessage: 'Feature'
    }),
    render: query => {
      var _query$feature$name, _query$feature3;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "hollow",
        onClickAriaLabel: _i18n.i18n.translate('xpack.streams.significantEventsTable.featureDetailsFlyoutAriaLabel', {
          defaultMessage: 'Open feature details'
        }),
        onClick: () => {
          var _query$feature;
          if ((_query$feature = query.feature) !== null && _query$feature !== void 0 && _query$feature.name) {
            setSelectedFeature(featuresByName[query.feature.name]);
          }
        },
        iconOnClick: () => {
          var _query$feature2;
          if ((_query$feature2 = query.feature) !== null && _query$feature2 !== void 0 && _query$feature2.name) {
            setSelectedFeature(featuresByName[query.feature.name]);
          }
        },
        iconOnClickAriaLabel: _i18n.i18n.translate('xpack.streams.significantEventsTable.featureDetailsFlyoutAriaLabel', {
          defaultMessage: 'Open feature details'
        }),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 83,
          columnNumber: 11
        }
      }, (_query$feature$name = (_query$feature3 = query.feature) === null || _query$feature3 === void 0 ? void 0 : _query$feature3.name) !== null && _query$feature$name !== void 0 ? _query$feature$name : '--');
    }
  }, {
    field: 'query',
    name: _i18n.i18n.translate('xpack.streams.significantEventsTable.queryText', {
      defaultMessage: 'Query'
    }),
    render: query => {
      if (!query.kql.query) {
        return '--';
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
        paddingSize: "none",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 123,
          columnNumber: 16
        }
      }, JSON.stringify(query.kql.query));
    }
  }, {
    field: 'occurrences',
    name: _i18n.i18n.translate('xpack.streams.significantEventsTable.occurrencesColumnTitle', {
      defaultMessage: 'Occurrences'
    }),
    render: (_, item) => {
      const change = (0, _change_point.formatChangePoint)(item);
      return /*#__PURE__*/_react.default.createElement(_significant_events_histogram.SignificantEventsHistogramChart, {
        id: item.query.id,
        occurrences: item.occurrences,
        change: change,
        xFormatter: xFormatter,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 135,
          columnNumber: 11
        }
      });
    }
  }, {
    name: _i18n.i18n.translate('xpack.streams.significantEventsTable.actionsColumnTitle', {
      defaultMessage: 'Actions'
    }),
    actions: [{
      name: _i18n.i18n.translate('xpack.streams.significantEventsTable.openInDiscoverActionTitle', {
        defaultMessage: 'Open in Discover'
      }),
      type: 'icon',
      icon: 'discoverApp',
      description: _i18n.i18n.translate('xpack.streams.significantEventsTable.openInDiscoverActionDescription', {
        defaultMessage: 'Open query in Discover'
      }),
      enabled: () => discoverLocator !== undefined,
      onClick: item => {
        discoverLocator === null || discoverLocator === void 0 ? void 0 : discoverLocator.navigate((0, _discover_helpers.buildDiscoverParams)(item.query, definition, timeState));
      },
      isPrimary: true
    }, {
      icon: 'pencil',
      type: 'icon',
      name: _i18n.i18n.translate('xpack.streams.significantEventsTable.editQueryActionTitle', {
        defaultMessage: 'Edit'
      }),
      description: _i18n.i18n.translate('xpack.streams.significantEventsTable.editQueryActionDescription', {
        defaultMessage: 'Edit query'
      }),
      isPrimary: true,
      onClick: item => {
        onEditClick === null || onEditClick === void 0 ? void 0 : onEditClick(item);
      }
    }, {
      icon: 'trash',
      type: 'icon',
      color: 'danger',
      name: _i18n.i18n.translate('xpack.streams.significantEventsTable.removeQueryActionTitle', {
        defaultMessage: 'Delete'
      }),
      description: _i18n.i18n.translate('xpack.streams.significantEventsTable.removeQueryActionDescription', {
        defaultMessage: 'Remove query from stream'
      }),
      onClick: item => {
        setIsDeleteModalVisible(true);
        setSelectedDeleteItem(item);
      }
    }]
  }];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    tableCaption: _i18n.i18n.translate('xpack.streams.significantEventsTable.tableCaption', {
      defaultMessage: 'Significant events'
    }),
    compressed: true,
    items: items,
    rowHeader: "title",
    columns: columns,
    loading: loading,
    tableLayout: "auto",
    itemId: "id",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 7
    }
  }), selectedFeature && /*#__PURE__*/_react.default.createElement(_stream_feature_details_flyout.StreamFeatureDetailsFlyout, {
    definition: definition,
    feature: selectedFeature,
    closeFlyout: () => {
      setSelectedFeature(undefined);
    },
    refreshFeatures: refreshFeatures,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 221,
      columnNumber: 9
    }
  }), isDeleteModalVisible && selectedDeleteItem && /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": 'deleteSignificantModal',
    title: _i18n.i18n.translate('xpack.streams.significantEventsTable.euiConfirmModal.deleteSignificantEventLabel', {
      defaultMessage: 'Delete significant event {name}',
      values: {
        name: selectedDeleteItem.query.title
      }
    }),
    titleProps: {
      id: 'deleteSignificantModal'
    },
    onCancel: () => setIsDeleteModalVisible(false),
    onConfirm: () => {
      setIsDeleteLoading(true);
      onDeleteClick === null || onDeleteClick === void 0 ? void 0 : onDeleteClick(selectedDeleteItem).finally(() => {
        setIsDeleteModalVisible(false);
        setSelectedDeleteItem(undefined);
        setIsDeleteLoading(false);
      });
    },
    cancelButtonText: _i18n.i18n.translate('xpack.streams.significantEventsTable.euiConfirmModal.cancelButtonLabel', {
      defaultMessage: 'Cancel'
    }),
    confirmButtonText: _i18n.i18n.translate('xpack.streams.significantEventsTable.euiConfirmModal.deleteSignificantEventButtonLabel', {
      defaultMessage: 'Delete significant event'
    }),
    isLoading: isDeleteLoading,
    buttonColor: "danger",
    defaultFocusedButton: "confirm",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 231,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 263,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.streams.significantEventsTable.euiConfirmModal.deleteSignificantEventMessage', {
    defaultMessage: 'Are you sure you want to delete the selected significant event? This action cannot be undone.'
  }))));
}