"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAIFeatures = useAIFeatures;
var _common = require("@kbn/streams-plugin/common");
var _lodash = require("lodash");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _use_kibana = require("../../../../hooks/use_kibana");
var _use_genai_connectors = require("../../../../hooks/use_genai_connectors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useAIFeatures() {
  var _core$application$cap;
  const {
    dependencies: {
      start: {
        licensing,
        streams
      }
    },
    core
  } = (0, _use_kibana.useKibana)();
  const isAIAvailableForTier = core.pricing.isFeatureAvailable(_common.STREAMS_TIERED_AI_FEATURE.id);
  const license = (0, _useObservable.default)(licensing.license$);
  const genAiConnectors = (0, _use_genai_connectors.useGenAIConnectors)({
    streamsRepositoryClient: streams.streamsRepositoryClient,
    uiSettings: core.uiSettings
  });

  // Check if actions plugin access is available (read permission)
  const hasActionsAccess = (_core$application$cap = core.application.capabilities.actions) === null || _core$application$cap === void 0 ? void 0 : _core$application$cap.show;
  if (!hasActionsAccess || !genAiConnectors) {
    return null;
  }
  const couldBeEnabled = Boolean(isAIAvailableForTier && (license === null || license === void 0 ? void 0 : license.hasAtLeast('enterprise')) && hasActionsAccess);
  const enabled = Boolean(couldBeEnabled && !(0, _lodash.isEmpty)(genAiConnectors.connectors));
  return {
    enabled,
    couldBeEnabled,
    genAiConnectors
  };
}