"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateQuery = validateQuery;
var _i18n = require("@kbn/i18n");
var _esQuery = require("@kbn/es-query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function validateQuery(query) {
  const {
    title = '',
    kql: {
      query: kqlQuery
    } = {
      query: ''
    }
  } = query;
  const isEmptyTitle = title.length === 0;
  const titleErrorMessage = isEmptyTitle ? _i18n.i18n.translate('xpack.streams.significantEventFlyout.formFieldTitleRequiredError', {
    defaultMessage: 'Required'
  }) : undefined;
  const isEmptyKql = kqlQuery.length === 0;
  let kqlSyntaxError = false;
  if (!isEmptyKql) {
    try {
      (0, _esQuery.fromKueryExpression)(kqlQuery);
    } catch (error) {
      kqlSyntaxError = true;
    }
  }
  const kqlErrorMessage = kqlSyntaxError ? _i18n.i18n.translate('xpack.streams.significantEventFlyout.formFieldQuerySyntaxError', {
    defaultMessage: 'Invalid syntax'
  }) : isEmptyKql ? _i18n.i18n.translate('xpack.streams.significantEventFlyout.formFieldQueryRequiredError', {
    defaultMessage: 'Required'
  }) : undefined;
  return {
    title: {
      isInvalid: Boolean(titleErrorMessage),
      error: titleErrorMessage
    },
    kql: {
      isInvalid: Boolean(kqlErrorMessage),
      error: kqlErrorMessage
    }
  };
}