"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QuickLinks = QuickLinks;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _css = require("@emotion/css");
var _use_dashboards_fetch = require("../../hooks/use_dashboards_fetch");
var _asset_image = require("../asset_image");
var _use_streams_app_router = require("../../hooks/use_streams_app_router");
var _attachment_table = require("../stream_detail_attachments/attachment_table");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/stream_detail_overview/quick_links.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const EMPTY_DASHBOARD_LIST = [];
function QuickLinks({
  definition
}) {
  var _dashboardsFetch$valu, _dashboardsFetch$valu2, _dashboardsFetch$valu3;
  const router = (0, _use_streams_app_router.useStreamsAppRouter)();
  const dashboardsFetch = (0, _use_dashboards_fetch.useDashboardsFetch)(definition.stream.name);
  if (definition && !dashboardsFetch.loading && ((_dashboardsFetch$valu = dashboardsFetch.value) === null || _dashboardsFetch$valu === void 0 ? void 0 : _dashboardsFetch$valu.dashboards.length) === 0) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 27,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      justifyContent: "center",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 28,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      className: (0, _css.css)`
              max-width: 200px;
            `,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 29,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 35,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_asset_image.AssetImage, {
      type: "quickLinksEmpty",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 36,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      textAlign: "center",
      color: "subdued",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 37,
        columnNumber: 15
      }
    }, _i18n.i18n.translate('xpack.streams.entityDetailOverview.linkDashboardsText', {
      defaultMessage: 'Link dashboards to this stream for quick access'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "center",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 42,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: router.link('/{key}/{tab}', {
        path: {
          key: definition.stream.name,
          tab: 'dashboards'
        }
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 43,
        columnNumber: 17
      }
    }, _i18n.i18n.translate('xpack.streams.entityDetailOverview.addDashboardButton', {
      defaultMessage: 'Add dashboards'
    })))))));
  }
  return /*#__PURE__*/_react.default.createElement(_attachment_table.AttachmentsTable, {
    attachments: (_dashboardsFetch$valu2 = (_dashboardsFetch$valu3 = dashboardsFetch.value) === null || _dashboardsFetch$valu3 === void 0 ? void 0 : _dashboardsFetch$valu3.dashboards) !== null && _dashboardsFetch$valu2 !== void 0 ? _dashboardsFetch$valu2 : EMPTY_DASHBOARD_LIST,
    loading: dashboardsFetch.loading,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 5
    }
  });
}