"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStreamFeatures = void 0;
var _react = require("react");
var _use_kibana = require("../../../../hooks/use_kibana");
var _use_streams_app_fetch = require("../../../../hooks/use_streams_app_fetch");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useStreamFeatures = definition => {
  const {
    streamsRepositoryClient
  } = (0, _use_kibana.useKibana)().dependencies.start.streams;
  const {
    value,
    loading,
    error,
    refresh
  } = (0, _use_streams_app_fetch.useStreamsAppFetch)(({
    signal
  }) => {
    return streamsRepositoryClient.fetch('GET /internal/streams/{name}/features', {
      signal,
      params: {
        path: {
          name: definition.name
        }
      }
    });
  }, [definition.name, streamsRepositoryClient]);
  const features = (0, _react.useMemo)(() => {
    var _value$features;
    return (_value$features = value === null || value === void 0 ? void 0 : value.features) !== null && _value$features !== void 0 ? _value$features : [];
  }, [value === null || value === void 0 ? void 0 : value.features]);
  const featuresByName = (0, _react.useMemo)(() => Object.fromEntries(features.map(f => [f.name, f])), [features]);
  return {
    refreshFeatures: refresh,
    features,
    featuresByName,
    featuresLoading: loading,
    error
  };
};
exports.useStreamFeatures = useStreamFeatures;