"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StreamDescription = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _connector_list_button = require("../connector_list_button/connector_list_button");
var _use_stream_description_api = require("./stream_description/use_stream_description_api");
var _row = require("../data_management/stream_detail_management/advanced_view/row");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/stream_detail_features/stream_description.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const STREAM_DESCRIPTION_PANEL_TITLE = _i18n.i18n.translate('xpack.streams.streamDetailView.streamDescription.panelTitle', {
  defaultMessage: 'Stream description'
});
const STREAM_DESCRIPTION_HELP = _i18n.i18n.translate('xpack.streams.streamDetailView.streamDescription.helpText', {
  defaultMessage: 'This is a natural language description of your data. This will be used in AI workflows like feature identification and significant event generation.'
});
const STREAM_DESCRIPTION_EMPTY = _i18n.i18n.translate('xpack.streams.streamDetailView.streamDescription.emptyText', {
  defaultMessage: 'No description'
});
const GENERATE_DESCRIPTION_BUTTON_LABEL = _i18n.i18n.translate('xpack.streams.streamDetailView.streamDescription.generateButtonLabel', {
  defaultMessage: 'Generate description'
});
const SAVE_DESCRIPTION_BUTTON_LABEL = _i18n.i18n.translate('xpack.streams.streamDetailView.streamDescription.saveDescriptionButtonLabel', {
  defaultMessage: 'Save'
});
const EDIT_DESCRIPTION_BUTTON_LABEL = _i18n.i18n.translate('xpack.streams.streamDetailView.streamDescription.editDescriptionButtonLabel', {
  defaultMessage: 'Edit'
});
const MANUAL_ENTRY_BUTTON_LABEL = _i18n.i18n.translate('xpack.streams.streamDetailView.streamDescription.manualEntryButtonLabel', {
  defaultMessage: 'Enter manually'
});
const CANCEL_LABEL = _i18n.i18n.translate('xpack.streams.streamDetailView.streamDescription.cancelButtonLabel', {
  defaultMessage: 'Cancel'
});
const StreamDescription = ({
  definition,
  refreshDefinition
}) => {
  const {
    isGenerating,
    description,
    isUpdating,
    isEditing,
    setDescription,
    onCancelEdit,
    onGenerateDescription,
    onSaveDescription,
    onStartEditing,
    areButtonsDisabled
  } = (0, _use_stream_description_api.useStreamDescriptionApi)({
    definition,
    refreshDefinition
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    hasShadow: false,
    paddingSize: "none",
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 11
    }
  }, STREAM_DESCRIPTION_PANEL_TITLE))), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "m",
    hasShadow: false,
    hasBorder: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 7
    }
  }, definition.stream.description || description || isEditing ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 13
    }
  }, STREAM_DESCRIPTION_HELP), /*#__PURE__*/_react.default.createElement(_eui.EuiMarkdownEditor, {
    value: description,
    onChange: setDescription,
    "aria-labelledby": "stream-description-editor",
    placeholder: STREAM_DESCRIPTION_EMPTY,
    readOnly: areButtonsDisabled || !isEditing,
    toolbarProps: {
      right: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        direction: "row",
        gutterSize: "s",
        justifyContent: "flexEnd",
        alignItems: "center",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 121,
          columnNumber: 19
        }
      }, isEditing && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 128,
          columnNumber: 23
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        "aria-label": CANCEL_LABEL,
        size: "s",
        isLoading: isUpdating,
        isDisabled: areButtonsDisabled,
        onClick: onCancelEdit,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 129,
          columnNumber: 25
        }
      }, CANCEL_LABEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 140,
          columnNumber: 21
        }
      }, /*#__PURE__*/_react.default.createElement(_connector_list_button.ConnectorListButton, {
        buttonProps: {
          size: 's',
          iconType: 'sparkles',
          children: GENERATE_DESCRIPTION_BUTTON_LABEL,
          onClick: onGenerateDescription,
          isDisabled: areButtonsDisabled,
          isLoading: isGenerating
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 141,
          columnNumber: 23
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 152,
          columnNumber: 21
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        iconType: isEditing ? 'save' : 'pencil',
        size: "s",
        iconSize: "s",
        fill: true,
        isLoading: isUpdating,
        isDisabled: areButtonsDisabled,
        onClick: () => {
          if (!isEditing) {
            onStartEditing();
          } else {
            onSaveDescription();
          }
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 153,
          columnNumber: 23
        }
      }, isEditing ? SAVE_DESCRIPTION_BUTTON_LABEL : EDIT_DESCRIPTION_BUTTON_LABEL)))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 13
    }
  })) : /*#__PURE__*/_react.default.createElement(_row.Row, {
    left: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 179,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      color: "subdued",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 180,
        columnNumber: 17
      }
    }, STREAM_DESCRIPTION_HELP)),
    right: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "row",
      gutterSize: "m",
      alignItems: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 186,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 187,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      isLoading: isUpdating,
      isDisabled: areButtonsDisabled,
      onClick: onStartEditing,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 188,
        columnNumber: 19
      }
    }, MANUAL_ENTRY_BUTTON_LABEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 196,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_connector_list_button.ConnectorListButton, {
      buttonProps: {
        fill: true,
        size: 'm',
        iconType: 'sparkles',
        children: GENERATE_DESCRIPTION_BUTTON_LABEL,
        onClick: onGenerateDescription,
        isDisabled: areButtonsDisabled,
        isLoading: isGenerating
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 197,
        columnNumber: 19
      }
    }))),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 11
    }
  })));
};
exports.StreamDescription = StreamDescription;