"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NestedView = NestedView;
var _react = _interopRequireDefault(require("react"));
var _css = require("@emotion/css");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/nested_view/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function NestedView({
  children,
  last,
  first,
  isBeingDragged
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return isBeingDragged ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children) : /*#__PURE__*/_react.default.createElement("div", {
    className: (0, _css.css)`
        padding-left: ${euiTheme.size.base};
        margin-left: 16px;
        border-left: ${last ? 'none' : euiTheme.border.thin};
        margin-top: -${euiTheme.size.xs}; //-4px
        padding-top: ${first ? '16px' : euiTheme.size.s}; //8px
        position: relative;

        &::before {
          content: '';
          border-bottom: ${euiTheme.border.thin};
          border-left: ${euiTheme.border.thin};
          position: absolute;
          top: 0;
          left: ${last ? '0px' : '-1px'};
          width: 26px;
          height: calc(50% + ${euiTheme.size.xs}); // Exactly half of the height of the panel
        }
      `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 5
    }
  }, children);
}