"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GroupStreamModificationFlyout = GroupStreamModificationFlyout;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _reactHooks = require("@kbn/react-hooks");
var _react = _interopRequireWildcard(require("react"));
var _use_kibana = require("../../hooks/use_kibana");
var _dashboards_tab = require("./dashboards_tab");
var _overview_tab = require("./overview_tab");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/group_stream_modification_flyout/group_stream_modification_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function GroupStreamModificationFlyout({
  client,
  notifications,
  streamsList,
  refresh,
  existingStream,
  existingDashboards,
  startingTab = 'overview'
}) {
  var _existingStream$name, _existingStream$descr, _existingStream$group, _existingStream$group2, _existingStream$group3, _streamsList$map, _tabs$find;
  const {
    dependencies: {
      start: {
        dashboard: dashboardStart
      }
    }
  } = (0, _use_kibana.useKibana)();
  const {
    signal
  } = (0, _reactHooks.useAbortController)();
  const [formData, setFormData] = _react.default.useState({
    name: (_existingStream$name = existingStream === null || existingStream === void 0 ? void 0 : existingStream.name) !== null && _existingStream$name !== void 0 ? _existingStream$name : '',
    description: (_existingStream$descr = existingStream === null || existingStream === void 0 ? void 0 : existingStream.description) !== null && _existingStream$descr !== void 0 ? _existingStream$descr : '',
    metadata: (_existingStream$group = existingStream === null || existingStream === void 0 ? void 0 : existingStream.group.metadata) !== null && _existingStream$group !== void 0 ? _existingStream$group : {},
    tags: (_existingStream$group2 = existingStream === null || existingStream === void 0 ? void 0 : existingStream.group.tags.map(tag => ({
      label: tag
    }))) !== null && _existingStream$group2 !== void 0 ? _existingStream$group2 : [],
    members: (_existingStream$group3 = existingStream === null || existingStream === void 0 ? void 0 : existingStream.group.members.map(member => ({
      label: member
    }))) !== null && _existingStream$group3 !== void 0 ? _existingStream$group3 : [],
    dashboards: []
  });
  (0, _react.useEffect)(() => {
    if (!existingDashboards) {
      return;
    }
    const enrichDashboards = async () => {
      const findDashboardsService = await dashboardStart.findDashboardsService();
      const searchResults = await findDashboardsService.findByIds(existingDashboards);
      setFormData(prevData => ({
        ...prevData,
        dashboards: searchResults.map(hit => ({
          id: hit.id,
          title: hit.status === 'success' ? hit.attributes.title : hit.id
        }))
      }));
    };
    enrichDashboards();
  }, [existingDashboards, dashboardStart]);
  async function modifyGroupStream() {
    let streamBaseData = {};
    if (existingStream) {
      streamBaseData = await client.fetch('GET /api/streams/{name} 2023-10-31', {
        params: {
          path: {
            name: formData.name
          }
        },
        signal
      });
    }
    client.fetch('PUT /api/streams/{name} 2023-10-31', {
      params: {
        path: {
          name: formData.name
        },
        body: {
          queries: [],
          rules: [],
          ...streamBaseData,
          dashboards: formData.dashboards.map(dashboard => dashboard.id),
          stream: {
            description: formData.description,
            group: {
              metadata: formData.metadata,
              tags: formData.tags.map(option => option.label),
              members: formData.members.map(opt => opt.label)
            }
          }
        }
      },
      signal
    }).then(() => {
      const successTitle = existingStream ? _i18n.i18n.translate('xpack.streams.groupStreamModificationFlyout.updatedSuccessToast', {
        defaultMessage: 'Group stream updated successfully'
      }) : _i18n.i18n.translate('xpack.streams.groupStreamModificationFlyout.createdSuccessToast', {
        defaultMessage: 'Group stream created successfully'
      });
      notifications.toasts.addSuccess({
        title: successTitle
      });
      refresh();
    }).catch(error => {
      notifications.toasts.addError(error, {
        title: existingStream ? _i18n.i18n.translate('xpack.streams.groupStreamModificationFlyout.updateFailedToast', {
          defaultMessage: 'Failed to update Group stream'
        }) : _i18n.i18n.translate('xpack.streams.groupStreamModificationFlyout.createFailedToast', {
          defaultMessage: 'Failed to create Group stream'
        })
      });
    });
  }
  const availableStreams = (_streamsList$map = streamsList === null || streamsList === void 0 ? void 0 : streamsList.map(stream => ({
    label: stream.stream.name
  }))) !== null && _streamsList$map !== void 0 ? _streamsList$map : [];
  const tabs = [{
    id: 'overview',
    name: _i18n.i18n.translate('xpack.streams.groupStreamModificationFlyout.overviewTabLabel', {
      defaultMessage: 'Overview'
    }),
    content: /*#__PURE__*/_react.default.createElement(_overview_tab.OverviewTab, {
      existingStream: !!existingStream,
      availableStreams: availableStreams,
      formData: formData,
      setFormData: setFormData,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 160,
        columnNumber: 9
      }
    })
  }, {
    id: 'dashboards',
    name: _i18n.i18n.translate('xpack.streams.groupStreamModificationFlyout.dashboardsTabLabel', {
      defaultMessage: 'Dashboards'
    }),
    content: /*#__PURE__*/_react.default.createElement(_dashboards_tab.DashboardsTab, {
      formData: formData,
      setFormData: setFormData,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 173,
        columnNumber: 16
      }
    })
  }];
  const [selectedTabId, setSelectedTabId] = (0, _react.useState)(startingTab);
  const onSelectedTabChanged = id => {
    setSelectedTabId(id);
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 9
    }
  }, existingStream ? _i18n.i18n.translate('xpack.streams.groupStreamModificationFlyout.editTitle', {
    defaultMessage: 'Edit {name}',
    values: {
      name: formData.name
    }
  }) : _i18n.i18n.translate('xpack.streams.groupStreamModificationFlyout.createTitle', {
    defaultMessage: 'Create Group stream'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 9
    }
  }, tabs.map((tab, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    key: index,
    onClick: () => onSelectedTabChanged(tab.id),
    isSelected: tab.id === selectedTabId,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 13
    }
  }, tab.name))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 9
    }
  }), (_tabs$find = tabs.find(obj => obj.id === selectedTabId)) === null || _tabs$find === void 0 ? void 0 : _tabs$find.content), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: modifyGroupStream,
    fill: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 212,
      columnNumber: 9
    }
  }, existingStream ? _i18n.i18n.translate('xpack.streams.groupStreamModificationFlyout.updateButtonLabel', {
    defaultMessage: 'Update'
  }) : _i18n.i18n.translate('xpack.streams.groupStreamModificationFlyout.createButtonLabel', {
    defaultMessage: 'Create'
  }))));
}