"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StreamNameFormRow = StreamNameFormRow;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _stream_routing_state_machine = require("./state_management/stream_routing_state_machine");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_routing/stream_name_form_row.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const MAX_NAME_LENGTH = 200;
const PREFIX_MAX_VISIBLE_CHARACTERS = 25;
function StreamNameFormRow({
  value,
  onChange = () => {},
  readOnly = false,
  autoFocus = false,
  error,
  isInvalid = false
}) {
  const descriptionId = (0, _eui.useGeneratedHtmlId)();
  const parentStreamName = (0, _stream_routing_state_machine.useStreamsRoutingSelector)(snapshot => snapshot.context.definition).stream.name;
  const prefix = parentStreamName + '.';
  const partitionName = value.replace(prefix, '');
  const isLengthValid = value.length > prefix.length && value.length <= MAX_NAME_LENGTH;
  const helpText = value.length >= MAX_NAME_LENGTH && !readOnly ? _i18n.i18n.translate('xpack.streams.streamDetailRouting.maximumNameHelpText', {
    defaultMessage: `Stream name cannot be longer than {maxLength} characters.`,
    values: {
      maxLength: MAX_NAME_LENGTH
    }
  }) : value.length <= prefix.length && !readOnly ? _i18n.i18n.translate('xpack.streams.streamDetailRouting.minimumNameHelpText', {
    defaultMessage: `Stream name is required.`
  }) : undefined;
  const isDotPresent = !readOnly && partitionName.includes('.');
  const dotErrorMessage = isDotPresent ? _i18n.i18n.translate('xpack.streams.streamDetailRouting.nameContainsDotErrorMessage', {
    defaultMessage: `Stream name cannot contain the "." character.`
  }) : undefined;
  const handleChange = e => {
    const newPartitionName = e.target.value;
    onChange(`${prefix}${newPartitionName}`);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.streams.streamDetailRouting.name', {
      defaultMessage: 'Stream name'
    }),
    helpText: helpText,
    describedByIds: [descriptionId],
    isInvalid: isInvalid || isDotPresent || !isLengthValid,
    error: error || dotErrorMessage,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    isInvalid: isInvalid || isDotPresent || !isLengthValid,
    "data-test-subj": "streamsAppRoutingStreamEntryNameField",
    value: partitionName,
    fullWidth: true,
    compressed: true,
    readOnly: readOnly,
    autoFocus: autoFocus,
    onChange: handleChange,
    maxLength: MAX_NAME_LENGTH - prefix.length,
    prepend: [/*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "streamsWired",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 101,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, {
      css: (0, _react2.css)`
              inline-size: min(${prefix.length}ch, ${PREFIX_MAX_VISIBLE_CHARACTERS}ch);
            `,
      id: descriptionId,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 102,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 108,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 109,
        columnNumber: 15
      }
    }, _i18n.i18n.translate('xpack.streams.streamDetailRouting.screenReaderPrefixLabel', {
      defaultMessage: 'Stream prefix:'
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiTextTruncate, {
      text: prefix,
      truncation: "start",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 115,
        columnNumber: 13
      }
    }))],
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 7
    }
  }));
}