"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RoutingConditionEditor = RoutingConditionEditor;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _streamsSchema = require("@kbn/streams-schema");
var _react = _interopRequireWildcard(require("react"));
var _use_field_suggestions = require("../../../hooks/use_field_suggestions");
var _use_stream_data_view_field_types = require("../../../hooks/use_stream_data_view_field_types");
var _use_value_suggestions = require("../../../hooks/use_value_suggestions");
var _condition = require("../../../util/condition");
var _condition_editor = require("../shared/condition_editor");
var _stream_routing_state_machine = require("./state_management/stream_routing_state_machine");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_routing/routing_condition_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function RoutingConditionEditor(props) {
  const {
    isSuggestionRouting,
    status
  } = props;
  const isEnabled = (0, _streamsSchema.isRoutingEnabled)(status);
  const fieldSuggestions = (0, _use_field_suggestions.useRoutingFieldSuggestions)();
  const valueSuggestions = (0, _use_value_suggestions.useRoutingValueSuggestions)((0, _condition.getFilterConditionField)(props.condition));

  // Get stream name for DataView field types
  const streamName = (0, _stream_routing_state_machine.useStreamSamplesSelector)(snapshot => snapshot.context.definition.stream.name);

  // Fetch DataView field types for displaying field type icons
  const {
    fieldTypeMap
  } = (0, _use_stream_data_view_field_types.useStreamDataViewFieldTypes)(streamName);

  // Enrich field suggestions with types from DataView
  const enrichedFieldSuggestions = (0, _react.useMemo)(() => {
    return fieldSuggestions.map(suggestion => ({
      ...suggestion,
      type: fieldTypeMap.get(suggestion.name)
    }));
  }, [fieldSuggestions, fieldTypeMap]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    fullWidth: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 5
    }
  }, !isSuggestionRouting && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "xs",
      alignItems: "center",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 55,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.streams.routing.conditionEditor.title', {
      defaultMessage: 'Status'
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: _i18n.i18n.translate('xpack.streams.routing.conditionEditor.disableTooltip', {
        defaultMessage: 'When disabled, the routing rule stops sending documents to this stream. It does not remove existing data.'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 59,
        columnNumber: 15
      }
    })),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: _i18n.i18n.translate('xpack.streams.routing.conditionEditor.switch', {
      defaultMessage: 'Enabled'
    }),
    compressed: true,
    checked: isEnabled,
    onChange: event => props.onStatusChange(event.target.checked ? 'enabled' : 'disabled'),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_condition_editor.ConditionEditor, (0, _extends2.default)({}, props, {
    fieldSuggestions: enrichedFieldSuggestions,
    valueSuggestions: valueSuggestions,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 7
    }
  })));
}