"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useReviewSuggestionsForm = useReviewSuggestionsForm;
var _react = require("react");
var _reactHooks = require("@kbn/react-hooks");
var _rxjs = require("rxjs");
var _lodash = require("lodash");
var _useUpdateEffect = _interopRequireDefault(require("react-use/lib/useUpdateEffect"));
var _use_streams_app_fetch = require("../../../../hooks/use_streams_app_fetch");
var _use_kibana = require("../../../../hooks/use_kibana");
var _stream_routing_state_machine = require("../state_management/stream_routing_state_machine");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useReviewSuggestionsForm() {
  const {
    core: {
      notifications
    },
    dependencies: {
      start: {
        streams: {
          streamsRepositoryClient
        }
      }
    }
  } = (0, _use_kibana.useKibana)();
  const streamName = (0, _stream_routing_state_machine.useStreamsRoutingSelector)(snapshot => snapshot.context.definition.stream.name);
  const streamsRoutingActorRef = (0, _stream_routing_state_machine.useStreamsRoutingActorRef)();
  const [suggestions, setSuggestions] = (0, _react.useState)(undefined);
  const [isLoadingSuggestions, setIsLoadingSuggestions] = (0, _react.useState)(false);
  const abortController = (0, _reactHooks.useAbortController)();
  const fetchSuggestions = async params => {
    setIsLoadingSuggestions(true);
    try {
      const response = await (0, _rxjs.lastValueFrom)(streamsRepositoryClient.stream('POST /internal/streams/{name}/_suggest_partitions', {
        signal: abortController.signal,
        params: {
          path: {
            name: params.streamName
          },
          body: {
            connector_id: params.connectorId,
            start: params.start,
            end: params.end
          }
        }
      }));
      setSuggestions(response.partitions);
    } catch (error) {
      if (error.name !== 'AbortError') {
        (0, _use_streams_app_fetch.showErrorToast)(notifications, error);
      }
    } finally {
      setIsLoadingSuggestions(false);
    }
  };
  const removeSuggestion = index => {
    if (!suggestions) return;
    const updatedSuggestions = suggestions.toSpliced(index, 1);

    // Reset form when all partitions are removed
    if ((0, _lodash.isEmpty)(updatedSuggestions)) {
      resetForm();
    } else {
      setSuggestions(updatedSuggestions);
    }
  };
  const updateSuggestion = (index, updates) => {
    if (!suggestions) return;
    const updatedSuggestion = {
      ...suggestions[index],
      ...updates
    };
    const updatedSuggestions = suggestions.toSpliced(index, 1, updatedSuggestion);
    setSuggestions(updatedSuggestions);
  };
  const resetPreview = () => {
    streamsRoutingActorRef.send({
      type: 'suggestion.preview',
      condition: {
        always: {}
      },
      name: '',
      index: 0,
      toggle: false
    });
  };
  const resetForm = () => {
    abortController.abort();
    abortController.refresh();
    setSuggestions(undefined);
    resetPreview();
  };

  // Reset suggestions when navigating to a different stream
  (0, _useUpdateEffect.default)(() => {
    resetForm();
  }, [streamName]);
  return {
    suggestions,
    removeSuggestion,
    isLoadingSuggestions,
    fetchSuggestions,
    resetForm,
    updateSuggestion,
    previewSuggestion: (index, toggle) => {
      if (suggestions) {
        const partition = suggestions[index];
        streamsRoutingActorRef.send({
          type: 'suggestion.preview',
          condition: partition.condition,
          name: partition.name,
          index,
          toggle
        });
      }
    },
    acceptSuggestion: removeSuggestion,
    rejectSuggestion: (index, isSelectedPreview = false) => {
      if (isSelectedPreview) {
        resetPreview();
      }
      removeSuggestion(index);
    }
  };
}