"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SuggestedStreamPanel = SuggestedStreamPanel;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _streamlang = require("@kbn/streamlang");
var _use_match_rate = require("./use_match_rate");
var _use_stream_routing = require("../state_management/stream_routing_state_machine/use_stream_routing");
var _selectable_panel = require("./selectable_panel");
var _shared = require("../../shared");
var _stream_name_form_row = require("../stream_name_form_row");
var _routing_condition_editor = require("../routing_condition_editor");
var _utils = require("../utils");
var _control_bars = require("../control_bars");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_routing/review_suggestions_form/suggested_stream_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function SuggestedStreamPanel({
  definition,
  partition,
  onDismiss,
  onPreview,
  index,
  onEdit,
  onSave
}) {
  const routingSnapshot = (0, _use_stream_routing.useStreamsRoutingSelector)(snapshot => snapshot);
  const {
    changeSuggestionName,
    changeSuggestionCondition,
    reviewSuggestedRule
  } = (0, _use_stream_routing.useStreamRoutingEvents)();
  const editedSuggestion = routingSnapshot.context.editedSuggestion;
  const isEditing = routingSnapshot.matches({
    ready: 'editingSuggestedRule'
  }) && routingSnapshot.context.editingSuggestionIndex === index;
  const currentSuggestion = isEditing && editedSuggestion ? editedSuggestion : partition;
  const matchRate = (0, _use_match_rate.useMatchRate)(definition, currentSuggestion);
  const selectedPreview = (0, _use_stream_routing.useStreamSamplesSelector)(snapshot => snapshot.context.selectedPreview);
  const isSelected = Boolean(selectedPreview && selectedPreview.type === 'suggestion' && selectedPreview.name === currentSuggestion.name);
  const nameError = _react.default.useMemo(() => {
    if (!isEditing) return undefined;
    const isDuplicateName = routingSnapshot.context.routing.some(r => r.destination === currentSuggestion.name);
    if (isDuplicateName) {
      return _i18n.i18n.translate('xpack.streams.streamDetailRouting.nameConflictError', {
        defaultMessage: 'A stream with this name already exists'
      });
    }
    return undefined;
  }, [isEditing, currentSuggestion.name, routingSnapshot.context.routing]);
  const conditionError = _react.default.useMemo(() => {
    if (!isEditing) return undefined;
    const processedCondition = (0, _utils.processCondition)(currentSuggestion.condition);
    const isProcessedCondition = processedCondition ? (0, _streamlang.isCondition)(processedCondition) : true;
    if (!isProcessedCondition) {
      return _i18n.i18n.translate('xpack.streams.streamDetailRouting.conditionRequiredError', {
        defaultMessage: 'Condition is required'
      });
    }
    return undefined;
  }, [isEditing, currentSuggestion.condition]);
  const handleNameChange = name => {
    if (!isEditing) return;
    changeSuggestionName(name);
  };
  const handleConditionChange = condition => {
    if (!isEditing) return;
    changeSuggestionCondition(condition);
  };
  if (isEditing) {
    return /*#__PURE__*/_react.default.createElement(_selectable_panel.SelectablePanel, {
      paddingSize: "m",
      isSelected: isSelected,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 117,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 118,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_stream_name_form_row.StreamNameFormRow, {
      value: currentSuggestion.name,
      onChange: handleNameChange,
      autoFocus: true,
      error: nameError,
      isInvalid: !!nameError,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 119,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_routing_condition_editor.RoutingConditionEditor, {
      status: "enabled",
      condition: currentSuggestion.condition,
      onConditionChange: handleConditionChange,
      onStatusChange: () => {},
      isSuggestionRouting: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 126,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_control_bars.EditSuggestedRuleControls, {
      onSave: onSave,
      onAccept: () => reviewSuggestedRule(currentSuggestion.name || partition.name),
      nameError: nameError,
      conditionError: conditionError,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 133,
        columnNumber: 11
      }
    })));
  }
  return /*#__PURE__*/_react.default.createElement(_selectable_panel.SelectablePanel, {
    paddingSize: "m",
    isSelected: isSelected,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 13
    }
  }, currentSuggestion.name))), matchRate.loading ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 13
    }
  })) : matchRate.value !== undefined ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "check",
    color: "success",
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "success",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 13
    }
  }, matchRate.value)) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_shared.VerticalRule, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "pencil",
    onClick: () => onEdit(index, currentSuggestion),
    "aria-label": _i18n.i18n.translate('xpack.streams.streamDetailRouting.edit', {
      defaultMessage: 'Edit'
    }),
    "data-test-subj": `suggestionEditButton-${currentSuggestion.name}`,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_shared.ConditionPanel, {
    condition: currentSuggestion.condition,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    justifyContent: "spaceBetween",
    wrap: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: isSelected ? 'eyeClosed' : 'eye',
    isSelected: isSelected,
    size: "s",
    onClick: () => onPreview(!isSelected),
    "aria-label": _i18n.i18n.translate('xpack.streams.streamDetailRouting.suggestedStreamPanel.preview', {
      defaultMessage: 'Preview'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.streams.streamDetailRouting.suggestedStreamPanel.preview', {
    defaultMessage: 'Preview'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    alignItems: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    onClick: onDismiss,
    "aria-label": _i18n.i18n.translate('xpack.streams.streamDetailRouting.suggestedStreamPanel.dismiss', {
      defaultMessage: 'Reject'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.streams.streamDetailRouting.suggestedStreamPanel.dismiss', {
    defaultMessage: 'Reject'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 216,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: "check",
    size: "s",
    onClick: () => reviewSuggestedRule(currentSuggestion.name || partition.name),
    fill: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.streams.streamDetailRouting.suggestedStreamPanel.accept', {
    defaultMessage: 'Accept'
  })))))));
}