"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PreviewPanel = PreviewPanel;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _streamlang = require("@kbn/streamlang");
var _streamsSchema = require("@kbn/streams-schema");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _use_doc_viewer_setup = require("../../../hooks/use_doc_viewer_setup");
var _use_document_expansion = require("../../../hooks/use_document_expansion");
var _use_stream_data_view_field_types = require("../../../hooks/use_stream_data_view_field_types");
var _asset_image = require("../../asset_image");
var _streams_app_search_bar = require("../../streams_app_search_bar");
var _shared = require("../shared");
var _cell_actions = require("./cell_actions");
var _document_match_filter_controls = require("./document_match_filter_controls");
var _stream_routing_state_machine = require("./state_management/stream_routing_state_machine");
var _utils = require("./utils");
var _preview_table = require("../shared/preview_table");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_routing/preview_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function PreviewPanel() {
  const routingSnapshot = (0, _stream_routing_state_machine.useStreamsRoutingSelector)(snapshot => snapshot);
  const {
    definition
  } = routingSnapshot.context;
  const canCreateRoutingRules = routingSnapshot.can({
    type: 'routingRule.create'
  });
  const maxNestingLevel = (0, _streamsSchema.getSegments)(definition.stream.name).length >= _streamsSchema.MAX_NESTING_LEVEL;
  let content;
  if (routingSnapshot.matches({
    ready: 'idle'
  })) {
    content = /*#__PURE__*/_react.default.createElement(SamplePreviewPanel, {
      enableActions: canCreateRoutingRules && !maxNestingLevel,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 48,
        columnNumber: 15
      }
    });
  } else if (routingSnapshot.matches({
    ready: 'editingRule'
  }) || routingSnapshot.matches({
    ready: 'reorderingRules'
  })) {
    content = /*#__PURE__*/_react.default.createElement(EditingPanel, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 53,
        columnNumber: 15
      }
    });
  } else if (routingSnapshot.matches({
    ready: 'creatingNewRule'
  }) || routingSnapshot.matches({
    ready: 'reviewSuggestedRule'
  }) || routingSnapshot.matches({
    ready: 'editingSuggestedRule'
  })) {
    content = /*#__PURE__*/_react.default.createElement(SamplePreviewPanel, {
      enableActions: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 59,
        columnNumber: 15
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": "routingPreviewPanel",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    wrap: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    component: "span",
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "inspect",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement("strong", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.streams.streamDetail.preview.header', {
    defaultMessage: 'Data Preview'
  }))), /*#__PURE__*/_react.default.createElement(_streams_app_search_bar.StreamsAppSearchBar, {
    showDatePicker: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 7
    }
  }, content));
}
const EditingPanel = () => /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
  icon: /*#__PURE__*/_react.default.createElement(_asset_image.AssetImage, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 11
    }
  }),
  titleSize: "xxs",
  title: /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('xpack.streams.streamDetail.preview.editPreviewMessage', {
    defaultMessage: 'Preview is not available while editing or reordering streams'
  })),
  body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.streams.streamDetail.preview.editPreviewMessageBody', {
    defaultMessage: 'Once you save your changes, the results of your conditions will appear here.'
  })), /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.streams.streamDetail.preview.editPreviewReorderingWarning', {
    defaultMessage: 'Additionally, you will not be able to edit existing streams while reordering them, you should save or cancel your changes first.'
  })))),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 83,
    columnNumber: 3
  }
});
const SamplePreviewPanel = ({
  enableActions
}) => {
  const samplesSnapshot = (0, _stream_routing_state_machine.useStreamSamplesSelector)(snapshot => snapshot);
  const {
    setDocumentMatchFilter,
    changeRule,
    createNewRule
  } = (0, _stream_routing_state_machine.useStreamRoutingEvents)();
  const isLoadingDocuments = samplesSnapshot.matches({
    fetching: {
      documents: 'loading'
    }
  });
  const isUpdating = samplesSnapshot.matches('debouncingCondition') || samplesSnapshot.matches({
    fetching: {
      documents: 'loading'
    }
  });
  const streamName = samplesSnapshot.context.definition.stream.name;
  const hasPrivileges = samplesSnapshot.context.definition.privileges.manage;
  const [viewMode, setViewMode] = (0, _react.useState)('summary');
  const {
    fieldTypes,
    dataView: streamDataView
  } = (0, _use_stream_data_view_field_types.useStreamDataViewFieldTypes)(streamName);
  const {
    documentsError,
    approximateMatchingPercentage
  } = samplesSnapshot.context;
  const documents = (0, _stream_routing_state_machine.selectPreviewDocuments)(samplesSnapshot.context);
  const condition = (0, _utils.processCondition)(samplesSnapshot.context.condition);
  const isProcessedCondition = condition ? (0, _streamlang.isCondition)(condition) : true;
  const hasDocuments = !(0, _lodash.isEmpty)(documents);
  const cellActions = (0, _react.useMemo)(() => {
    if (!enableActions) {
      return [];
    }
    return (0, _cell_actions.buildCellActions)(documents, createNewRule, changeRule);
  }, [enableActions, documents, createNewRule, changeRule]);
  const [sorting, setSorting] = (0, _react.useState)();
  const [visibleColumns, setVisibleColumns] = (0, _react.useState)();
  const handleSetVisibleColumns = (0, _react.useCallback)(newVisibleColumns => {
    setVisibleColumns(newVisibleColumns.length > 0 ? newVisibleColumns : undefined);
  }, []);
  const docViewsRegistry = (0, _use_doc_viewer_setup.useDocViewerSetup)();
  const hits = (0, _react.useMemo)(() => {
    return (0, _utils.toDataTableRecordWithIndex)(documents);
  }, [documents]);
  const {
    currentDoc,
    selectedRowIndex,
    onRowSelected,
    setExpandedDoc
  } = (0, _use_document_expansion.useDocumentExpansion)(hits);
  const rowSelectionContextValue = (0, _react.useMemo)(() => ({
    selectedRowIndex,
    onRowSelected
  }), [selectedRowIndex, onRowSelected]);
  let content = null;
  if (isLoadingDocuments && !hasDocuments) {
    content = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "center",
      alignItems: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 171,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingElastic, {
      size: "xl",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 172,
        columnNumber: 9
      }
    }));
  } else if (documentsError) {
    content = /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      icon: /*#__PURE__*/_react.default.createElement(_asset_image.AssetImage, {
        type: "noResults",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 178,
          columnNumber: 15
        }
      }),
      color: "danger",
      titleSize: "s",
      title: /*#__PURE__*/_react.default.createElement("h2", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 182,
          columnNumber: 11
        }
      }, _i18n.i18n.translate('xpack.streams.streamDetail.preview.error', {
        defaultMessage: 'Error loading preview'
      })),
      body: documentsError.message,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 177,
        columnNumber: 7
      }
    });
  } else if (!hasDocuments || !isProcessedCondition) {
    content = /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      icon: /*#__PURE__*/_react.default.createElement(_asset_image.AssetImage, {
        type: "noResults",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 194,
          columnNumber: 15
        }
      }),
      titleSize: "xxs",
      title: /*#__PURE__*/_react.default.createElement("h2", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 197,
          columnNumber: 11
        }
      }, _i18n.i18n.translate('xpack.streams.streamDetail.preview.empty', {
        defaultMessage: 'No documents to preview'
      })),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 193,
        columnNumber: 7
      }
    });
  } else if (hasDocuments) {
    content = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: true,
      "data-test-subj": "routingPreviewPanelWithResults",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 207,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_preview_table.RowSelectionContext.Provider, {
      value: rowSelectionContextValue,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 208,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_shared.MemoPreviewTable, {
      documents: documents,
      sorting: sorting,
      setSorting: setSorting,
      toolbarVisibility: true,
      displayColumns: visibleColumns,
      setVisibleColumns: handleSetVisibleColumns,
      cellActions: cellActions,
      mode: viewMode,
      streamName: streamName,
      viewModeToggle: {
        currentMode: viewMode,
        setViewMode,
        isDisabled: false
      },
      dataViewFieldTypes: fieldTypes,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 209,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_shared.PreviewFlyout, {
      currentDoc: currentDoc,
      hits: hits,
      setExpandedDoc: setExpandedDoc,
      docViewsRegistry: docViewsRegistry,
      streamName: streamName,
      streamDataView: streamDataView,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 227,
        columnNumber: 9
      }
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isUpdating && /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "xs",
    color: "accent",
    position: "absolute",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 241,
      columnNumber: 22
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 242,
      columnNumber: 7
    }
  }, hasPrivileges ? /*#__PURE__*/_react.default.createElement(_document_match_filter_controls.DocumentMatchFilterControls, {
    onFilterChange: setDocumentMatchFilter,
    matchedDocumentPercentage: approximateMatchingPercentage,
    isDisabled: !!documentsError || !condition || condition && !isProcessedCondition,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 244,
      columnNumber: 11
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 250,
      columnNumber: 11
    }
  }), content));
};