"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StreamDetailManagement = StreamDetailManagement;
var _react = _interopRequireDefault(require("react"));
var _streamsSchema = require("@kbn/streams-schema");
var _use_stream_detail = require("../../../hooks/use_stream_detail");
var _wired = require("./wired");
var _classic = require("./classic");
var _group = require("./group");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_management/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function StreamDetailManagement() {
  const {
    definition,
    refresh
  } = (0, _use_stream_detail.useStreamDetail)();
  if (_streamsSchema.Streams.WiredStream.GetResponse.is(definition)) {
    return /*#__PURE__*/_react.default.createElement(_wired.WiredStreamDetailManagement, {
      definition: definition,
      refreshDefinition: refresh,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 18,
        columnNumber: 12
      }
    });
  }
  if (_streamsSchema.Streams.GroupStream.GetResponse.is(definition)) {
    return /*#__PURE__*/_react.default.createElement(_group.GroupStreamDetailManagement, {
      definition: definition,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 22,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_classic.ClassicStreamDetailManagement, {
    definition: definition,
    refreshDefinition: refresh,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 25,
      columnNumber: 10
    }
  });
}