"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GroupStreamControls = GroupStreamControls;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _reactHooks = require("@kbn/react-hooks");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _react = _interopRequireDefault(require("react"));
var _use_streams_app_params = require("../../../hooks/use_streams_app_params");
var _use_discard_confirm = require("../../../hooks/use_discard_confirm");
var _use_stream_detail = require("../../../hooks/use_stream_detail");
var _use_kibana = require("../../../hooks/use_kibana");
var _use_streams_app_router = require("../../../hooks/use_streams_app_router");
var _use_streams_app_fetch = require("../../../hooks/use_streams_app_fetch");
var _group_stream_modification_flyout = require("../../group_stream_modification_flyout/group_stream_modification_flyout");
var _streams_app_context_provider = require("../../streams_app_context_provider");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_management/group_stream_controls.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function GroupStreamControls() {
  const router = (0, _use_streams_app_router.useStreamsAppRouter)();
  const context = (0, _use_kibana.useKibana)();
  const {
    core,
    dependencies: {
      start: {
        streams: {
          streamsRepositoryClient
        }
      }
    }
  } = context;
  const streamsListFetch = (0, _use_streams_app_fetch.useStreamsAppFetch)(async ({
    signal
  }) => {
    const {
      streams
    } = await streamsRepositoryClient.fetch('GET /internal/streams', {
      signal
    });
    return streams;
  }, [streamsRepositoryClient]);
  const {
    definition,
    refresh: refreshDefinition
  } = (0, _use_stream_detail.useStreamDetail)();
  const overlayRef = _react.default.useRef(null);
  const {
    signal
  } = (0, _reactHooks.useAbortController)();
  const {
    path
  } = (0, _use_streams_app_params.useStreamsAppParams)('/{key}/management/{tab}', true);
  function openGroupStreamModificationFlyout() {
    var _overlayRef$current;
    (_overlayRef$current = overlayRef.current) === null || _overlayRef$current === void 0 ? void 0 : _overlayRef$current.close();
    overlayRef.current = core.overlays.openFlyout((0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_streams_app_context_provider.StreamsAppContextProvider, {
      context: context,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 53,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_group_stream_modification_flyout.GroupStreamModificationFlyout, {
      client: streamsRepositoryClient,
      streamsList: streamsListFetch.value,
      refresh: () => {
        var _overlayRef$current2;
        refreshDefinition();
        (_overlayRef$current2 = overlayRef.current) === null || _overlayRef$current2 === void 0 ? void 0 : _overlayRef$current2.close();
      },
      notifications: core.notifications,
      existingStream: definition.stream,
      existingDashboards: definition.dashboards,
      startingTab: path.tab === 'dashboards' ? 'dashboards' : 'overview',
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 54,
        columnNumber: 11
      }
    })), core), {
      size: 's'
    });
  }
  function deleteGroupStream() {
    streamsRepositoryClient.fetch('DELETE /api/streams/{name} 2023-10-31', {
      params: {
        path: {
          name: definition.stream.name
        }
      },
      signal
    }).then(() => {
      core.notifications.toasts.addSuccess(_i18n.i18n.translate('xpack.streams.groupStreamDetailView.deleteSuccessToastMessage', {
        defaultMessage: '{name} was deleted',
        values: {
          name: definition.stream.name
        }
      }));
      router.push('/', {
        path: {},
        query: {}
      });
    }).catch(error => {
      core.notifications.toasts.addError(error, {
        title: _i18n.i18n.translate('xpack.streams.groupStreamDetailView.deleteErrorToastMessage', {
          defaultMessage: 'Failed to delete {name}',
          values: {
            name: definition.stream.name
          }
        })
      });
    });
  }
  const handleDeleteClick = (0, _use_discard_confirm.useDiscardConfirm)(deleteGroupStream, {
    title: _i18n.i18n.translate('xpack.streams.groupStreamDetailView.deleteModalTitle', {
      defaultMessage: 'Delete {name}?',
      values: {
        name: definition.stream.name
      }
    }),
    message: _i18n.i18n.translate('xpack.streams.groupStreamDetailView.deleteModalMessage', {
      defaultMessage: 'Are you sure you want to delete {name}?',
      values: {
        name: definition.stream.name
      }
    }),
    cancelButtonText: _i18n.i18n.translate('xpack.streams.groupStreamDetailView.deleteModalCancelButton', {
      defaultMessage: 'Cancel'
    }),
    confirmButtonText: _i18n.i18n.translate('xpack.streams.groupStreamDetailView.deleteModalConfirmButton', {
      defaultMessage: 'Delete'
    }),
    defaultFocusedButton: 'cancel'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    justifyContent: "flexEnd",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: openGroupStreamModificationFlyout,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.streams.groupStreamDetailView.editButtonLabel', {
    defaultMessage: 'Edit'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "danger",
    onClick: handleDeleteClick,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.streams.groupStreamDetailView.deleteButtonLabel', {
    defaultMessage: 'Delete'
  }))));
}