"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFailureStoreDefaultRetention = useFailureStoreDefaultRetention;
var _use_kibana = require("../../../../hooks/use_kibana");
var _use_streams_app_fetch = require("../../../../hooks/use_streams_app_fetch");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useFailureStoreDefaultRetention(streamName) {
  const {
    dependencies: {
      start: {
        streams: {
          streamsRepositoryClient
        }
      }
    }
  } = (0, _use_kibana.useKibana)();
  const result = (0, _use_streams_app_fetch.useStreamsAppFetch)(async ({
    signal
  }) => {
    try {
      const response = await streamsRepositoryClient.fetch('GET /internal/streams/{name}/failure_store/default_retention', {
        signal,
        params: {
          path: {
            name: streamName
          }
        }
      });
      return response.default_retention;
    } catch (error) {
      // If we can't fetch it, just return undefined
      return undefined;
    }
  }, [streamName, streamsRepositoryClient], {
    disableToastOnError: true
  });
  return {
    value: result.value,
    refresh: result.refresh
  };
}