"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformFailureStoreConfig = transformFailureStoreConfig;
exports.useFailureStoreConfig = useFailureStoreConfig;
var _streamsSchema = require("@kbn/streams-schema");
var _failure_store = require("@kbn/streams-schema/src/models/ingest/failure_store");
var _use_failure_store_default_retention = require("./use_failure_store_default_retention");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function transformFailureStoreConfig(update) {
  var _update$failureStoreE;
  const failureStoreEnabled = (_update$failureStoreE = update.failureStoreEnabled) !== null && _update$failureStoreE !== void 0 ? _update$failureStoreE : false;

  // Inherit
  if ('inherit' in update && update.inherit) {
    return {
      inherit: {}
    };
  }

  // Disabled
  if (!failureStoreEnabled) {
    return {
      disabled: {}
    };
  }

  // Disabled lifecycle
  if ('retentionDisabled' in update && update.retentionDisabled) {
    return {
      lifecycle: {
        disabled: {}
      }
    };
  }

  // Enabled
  const customRetentionPeriod = 'customRetentionPeriod' in update ? update.customRetentionPeriod : undefined;
  return {
    lifecycle: {
      enabled: {
        data_retention: customRetentionPeriod
      }
    }
  };
}
function useFailureStoreConfig(definition) {
  const {
    effective_failure_store: failureStore
  } = definition;
  const isWired = _streamsSchema.Streams.WiredStream.GetResponse.is(definition);
  const isClassicStream = _streamsSchema.Streams.ClassicStream.GetResponse.is(definition);
  const isRootStream = (0, _streamsSchema.isRoot)(definition.stream.name);
  const failureStoreEnabled = (0, _streamsSchema.isEnabledFailureStore)(failureStore);
  const {
    value: defaultRetentionPeriod,
    refresh: refreshDefaultRetention
  } = (0, _use_failure_store_default_retention.useFailureStoreDefaultRetention)(definition.stream.name);
  const retentionDisabled = (0, _failure_store.isDisabledLifecycleFailureStore)(failureStore);
  const customRetentionPeriod = failureStoreEnabled && !retentionDisabled ? failureStore.lifecycle.enabled.data_retention : undefined;
  const isCurrentlyInherited = (0, _failure_store.isInheritFailureStore)(definition.stream.ingest.failure_store);
  const canShowInherit = isWired && !isRootStream || isClassicStream;
  return {
    defaultRetentionPeriod,
    customRetentionPeriod,
    failureStoreEnabled,
    inheritOptions: {
      canShowInherit,
      isWired,
      isCurrentlyInherited
    },
    retentionDisabled,
    refreshDefaultRetention
  };
}