"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IngestionCard = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _base_metric_card = require("../../common/base_metric_card");
var _format_bytes = require("../../helpers/format_bytes");
var _insufficient_privileges = require("../../../../insufficient_privileges/insufficient_privileges");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_lifecycle/general_data/cards/ingestion_card.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const IngestionCard = ({
  hasMonitorPrivileges,
  stats,
  statsError
}) => {
  const inaccurateMetric = Boolean((stats === null || stats === void 0 ? void 0 : stats.hasFailureStore) && !stats.userPrivileges.canManageFailureStore);
  const title = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.streams.streamDetailLifecycle.ingestion.title",
    defaultMessage: "Ingestion averages {tooltipIcon}",
    values: {
      tooltipIcon: /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        type: "question",
        title: _i18n.i18n.translate('xpack.streams.ingestionCard.tooltipTitle', {
          defaultMessage: 'How we calculate ingestion averages'
        }),
        content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.streams.ingestionCard.tooltip.description', {
          defaultMessage: 'Approximate average, calculated by extrapolating the ingestion rate from the documents on the selected time range and the average document size.'
        }), inaccurateMetric && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
          size: "xs",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 48,
            columnNumber: 21
          }
        }), _i18n.i18n.translate('xpack.streams.ingestionCard.tooltip.privilegesWarning', {
          defaultMessage: 'These averages may not be accurate because you lack sufficient privileges to access all the data.'
        }))),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 34,
          columnNumber: 11
        }
      })
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 5
    }
  });
  const metrics = [{
    data: /*#__PURE__*/_react.default.createElement(_insufficient_privileges.PrivilegesWarningIconWrapper, {
      hasPrivileges: hasMonitorPrivileges,
      title: _i18n.i18n.translate('xpack.streams.ingestionCard.privilegesWarningIconWrapper.ingestiondailyLabel', {
        defaultMessage: 'ingestionDaily'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 67,
        columnNumber: 9
      }
    }, statsError || !stats || stats.bytesPerDay === undefined ? '-' : (0, _format_bytes.formatBytes)(stats.bytesPerDay)),
    subtitle: _i18n.i18n.translate('xpack.streams.streamDetailView.failureStoreEnabled.failedIngestionCard.dailyAverage', {
      defaultMessage: 'Daily average'
    }),
    'data-test-subj': 'ingestion-daily'
  }, {
    data: /*#__PURE__*/_react.default.createElement(_insufficient_privileges.PrivilegesWarningIconWrapper, {
      hasPrivileges: hasMonitorPrivileges,
      title: _i18n.i18n.translate('xpack.streams.ingestionCard.privilegesWarningIconWrapper.ingestionmonthlyLabel', {
        defaultMessage: 'ingestionMonthly'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 89,
        columnNumber: 9
      }
    }, statsError || !stats || stats.bytesPerDay === undefined ? '-' : (0, _format_bytes.formatBytes)(stats.bytesPerDay * 30)),
    subtitle: _i18n.i18n.translate('xpack.streams.streamDetailView.failureStoreEnabled.failedIngestionCard.monthlyAverage', {
      defaultMessage: 'Monthly average'
    }),
    'data-test-subj': 'ingestion-monthly'
  }];
  return /*#__PURE__*/_react.default.createElement(_base_metric_card.BaseMetricCard, {
    title: title,
    metrics: metrics,
    "data-test-subj": "ingestionCard",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 10
    }
  });
};
exports.IngestionCard = IngestionCard;