"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getNestedMessage = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const statusLabels = {
  pending: _i18n.i18n.translate('xpack.streams.nestedChildrenProcessingSummary.pending', {
    defaultMessage: 'pending'
  }),
  running: _i18n.i18n.translate('xpack.streams.nestedChildrenProcessingSummary.running', {
    defaultMessage: 'running'
  }),
  failed: _i18n.i18n.translate('xpack.streams.nestedChildrenProcessingSummary.failed', {
    defaultMessage: 'failed'
  }),
  successful: _i18n.i18n.translate('xpack.streams.nestedChildrenProcessingSummary.successful', {
    defaultMessage: 'successful'
  }),
  disabled: _i18n.i18n.translate('xpack.streams.nestedChildrenProcessingSummary.disabled', {
    defaultMessage: 'disabled'
  }),
  skipped: _i18n.i18n.translate('xpack.streams.nestedChildrenProcessingSummary.skipped', {
    defaultMessage: 'skipped'
  })
};
const getNestedMessage = (statusCounts, stepsCount, conditionsCount) => {
  const hasSteps = stepsCount > 0;
  const hasConditions = conditionsCount > 0;

  // Build strings conditionally (only what's needed)
  const statusSummary = hasSteps ? Object.entries(statusCounts).map(([status, count]) => `${count} ${statusLabels[status] || status}`).join(', ') : '';
  const stepsLabel = hasSteps ? _i18n.i18n.translate('xpack.streams.nestedChildrenProcessingSummary.stepsLabel', {
    defaultMessage: '{count, plural, one {step} other {steps}}',
    values: {
      count: stepsCount
    }
  }) : '';
  const conditionLabel = hasConditions ? _i18n.i18n.translate('xpack.streams.nestedChildrenProcessingSummary.conditionStepsLabel', {
    defaultMessage: '{count, plural, one {nested condition} other {nested conditions}}',
    values: {
      count: conditionsCount
    }
  }) : '';
  const andLabel = hasSteps && hasConditions ? _i18n.i18n.translate('xpack.streams.nestedChildrenProcessingSummary.and', {
    defaultMessage: 'and'
  }) : '';

  // Compose and return based on what's present
  if (hasSteps && !hasConditions) {
    return `${statusSummary} ${stepsLabel}`;
  }
  if (!hasSteps && hasConditions) {
    return `${conditionsCount} ${conditionLabel}`;
  }
  if (hasSteps && hasConditions) {
    return `${statusSummary} ${stepsLabel} ${andLabel} ${conditionsCount} ${conditionLabel}`;
  }
  return '';
};
exports.getNestedMessage = getNestedMessage;