"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.saveConditionPromptOptions = exports.discardChangesPromptOptions = exports.deleteConditionPromptOptions = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const discardChangesPromptOptions = exports.discardChangesPromptOptions = {
  message: _i18n.i18n.translate('xpack.streams.enrichment.processor.discardChanges.message', {
    defaultMessage: 'Are you sure you want to discard your changes?'
  }),
  title: _i18n.i18n.translate('xpack.streams.enrichment.processor.discardChanges.title', {
    defaultMessage: 'Discard changes?'
  }),
  confirmButtonText: _i18n.i18n.translate('xpack.streams.enrichment.processor.discardChanges.confirmButtonText', {
    defaultMessage: 'Discard'
  }),
  cancelButtonText: _i18n.i18n.translate('xpack.streams.enrichment.processor.discardChanges.cancelButtonText', {
    defaultMessage: 'Keep editing'
  })
};

// NOTE: Message is added dynamically as it contains the child count
const deleteConditionPromptOptions = exports.deleteConditionPromptOptions = {
  title: _i18n.i18n.translate('xpack.streams.enrichment.condition.deleteCondition.title', {
    defaultMessage: 'Are you sure you want to delete this condition?'
  }),
  confirmButtonText: _i18n.i18n.translate('xpack.streams.enrichment.condition.deleteCondition.confirmButtonText', {
    defaultMessage: 'Delete condition'
  }),
  cancelButtonText: _i18n.i18n.translate('xpack.streams.enrichment.condition.deleteCondition.cancelButtonText', {
    defaultMessage: 'Cancel'
  })
};

// NOTE: Message is added dynamically as it contains the child count
const saveConditionPromptOptions = exports.saveConditionPromptOptions = {
  title: _i18n.i18n.translate('xpack.streams.enrichment.condition.saveCondition.title', {
    defaultMessage: 'Update this item'
  }),
  confirmButtonText: _i18n.i18n.translate('xpack.streams.enrichment.condition.saveCondition.confirmButtonText', {
    defaultMessage: 'Update'
  }),
  cancelButtonText: _i18n.i18n.translate('xpack.streams.enrichment.condition.saveCondition.cancelButtonText', {
    defaultMessage: 'Cancel'
  })
};