"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NestedChildrenProcessingSummary = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _utils = require("./utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_enrichment/steps/blocks/where/nested_children_processing_summary.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const NestedChildrenProcessingSummary = ({
  childIds,
  stepsProcessingSummaryMap
}) => {
  if (!stepsProcessingSummaryMap) return null;
  const statusCounts = {};
  let stepsCount = 0;
  let conditionsCount = 0;
  for (const id of childIds) {
    const status = stepsProcessingSummaryMap.get(id);
    if (status) {
      if (status === 'disabled.processorBeforePersisted') {
        statusCounts.disabled = (statusCounts.disabled || 0) + 1;
        stepsCount++;
      } else if (status === 'skipped.followsProcessorBeingEdited' || status === 'skipped.createdInPreviousSimulation') {
        statusCounts.skipped = (statusCounts.skipped || 0) + 1;
        stepsCount++;
      } else if (status === 'condition') {
        conditionsCount++;
      } else {
        statusCounts[status] = (statusCounts[status] || 0) + 1;
        stepsCount++;
      }
    }
  }
  const message = (0, _utils.getNestedMessage)(statusCounts, stepsCount, conditionsCount);
  return message ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 5
    }
  }, message) : null;
};
exports.NestedChildrenProcessingSummary = NestedChildrenProcessingSummary;