"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReplaceTargetFieldSelector = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _reactHookForm = require("react-hook-form");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_enrichment/steps/blocks/action/replace/target_field.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ReplaceTargetFieldSelector = () => {
  var _errors$to;
  const {
    register,
    formState: {
      errors
    }
  } = (0, _reactHookForm.useFormContext)();
  const {
    ref,
    ...inputProps
  } = register('to');
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.replaceTargetFieldLabel', {
      defaultMessage: 'Target field'
    }),
    helpText: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.replaceTargetFieldHelpText', {
      defaultMessage: 'Output field. Leave empty to update the source field.'
    }),
    isInvalid: Boolean(errors.to),
    error: (_errors$to = errors.to) === null || _errors$to === void 0 ? void 0 : _errors$to.message,
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 23,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, (0, _extends2.default)({
    isInvalid: Boolean(errors.to)
  }, inputProps, {
    inputRef: ref,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 7
    }
  })));
};
exports.ReplaceTargetFieldSelector = ReplaceTargetFieldSelector;