"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReplaceProcessorForm = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _reactHookForm = require("react-hook-form");
var _processor_field_selector = require("../processor_field_selector");
var _optional_fields_accordion = require("../optional_fields_accordion");
var _ignore_toggles = require("../ignore_toggles");
var _processor_condition_editor = require("../processor_condition_editor");
var _target_field = require("./target_field");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_enrichment/steps/blocks/action/replace/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ReplaceProcessorForm = () => {
  var _patternFieldState$er, _replacementFieldStat;
  const {
    field: patternField,
    fieldState: patternFieldState
  } = (0, _reactHookForm.useController)({
    name: 'pattern',
    rules: {
      required: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.replacePatternRequiredError', {
        defaultMessage: 'Pattern is required.'
      })
    }
  });
  const {
    field: replacementField,
    fieldState: replacementFieldState
  } = (0, _reactHookForm.useController)({
    name: 'replacement'
    // No validation - empty string is valid (removes the pattern)
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_processor_field_selector.ProcessorFieldSelector, {
    fieldKey: "from",
    helpText: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.replaceFieldHelpText', {
      defaultMessage: 'The field to apply the replacement to.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.replacePatternLabel', {
      defaultMessage: 'Pattern'
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.streams.streamDetailView.managementTab.enrichment.processor.replacePatternHelpText",
      defaultMessage: "Text or regex pattern that identifies what to replace with the replacement string. For example, use {regexExample} to replace a space.",
      values: {
        regexExample: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 63,
            columnNumber: 29
          }
        }, "\\s")
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 59,
        columnNumber: 11
      }
    }),
    isInvalid: patternFieldState.invalid,
    error: (_patternFieldState$er = patternFieldState.error) === null || _patternFieldState$er === void 0 ? void 0 : _patternFieldState$er.message,
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, (0, _extends2.default)({
    isInvalid: patternFieldState.invalid
  }, patternField, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 9
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.replaceReplacementLabel', {
      defaultMessage: 'Replacement'
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.streams.streamDetailView.managementTab.enrichment.processor.replaceReplacementHelpText",
      defaultMessage: "Value that replaces any matches of the pattern. It can be text, an empty value, or a capture group reference (for example, {captureGroupExample}).",
      values: {
        captureGroupExample: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 85,
            columnNumber: 19
          }
        }, "$1"), ", ", /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 85,
            columnNumber: 42
          }
        }, "$2"))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 79,
        columnNumber: 11
      }
    }),
    isInvalid: replacementFieldState.invalid,
    error: (_replacementFieldStat = replacementFieldState.error) === null || _replacementFieldStat === void 0 ? void 0 : _replacementFieldStat.message,
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, (0, _extends2.default)({
    isInvalid: replacementFieldState.invalid
  }, replacementField, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 9
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_target_field.ReplaceTargetFieldSelector, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_optional_fields_accordion.FieldsAccordion, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_processor_condition_editor.ProcessorConditionEditor, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_ignore_toggles.IgnoreFailureToggle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_ignore_toggles.IgnoreMissingToggle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 7
    }
  }));
};
exports.ReplaceProcessorForm = ReplaceProcessorForm;