"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.discardChangesPromptOptions = exports.deleteProcessorPromptOptions = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const discardChangesPromptOptions = exports.discardChangesPromptOptions = {
  message: _i18n.i18n.translate('xpack.streams.enrichment.processor.discardChanges.message', {
    defaultMessage: 'Are you sure you want to discard your changes?'
  }),
  title: _i18n.i18n.translate('xpack.streams.enrichment.processor.discardChanges.title', {
    defaultMessage: 'Discard changes?'
  }),
  confirmButtonText: _i18n.i18n.translate('xpack.streams.enrichment.processor.discardChanges.confirmButtonText', {
    defaultMessage: 'Discard'
  }),
  cancelButtonText: _i18n.i18n.translate('xpack.streams.enrichment.processor.discardChanges.cancelButtonText', {
    defaultMessage: 'Keep editing'
  })
};
const deleteProcessorPromptOptions = exports.deleteProcessorPromptOptions = {
  message: _i18n.i18n.translate('xpack.streams.enrichment.processor.deleteProcessor.message', {
    defaultMessage: 'Deleting this processor will permanently impact the field configuration.'
  }),
  title: _i18n.i18n.translate('xpack.streams.enrichment.processor.deleteProcessor.title', {
    defaultMessage: 'Are you sure you want to delete this processor?'
  }),
  confirmButtonText: _i18n.i18n.translate('xpack.streams.enrichment.processor.deleteProcessor.confirmButtonText', {
    defaultMessage: 'Delete processor'
  }),
  cancelButtonText: _i18n.i18n.translate('xpack.streams.enrichment.processor.deleteProcessor.cancelButtonText', {
    defaultMessage: 'Cancel'
  })
};