"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProcessorTypeSelector = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _reactHookForm = require("react-hook-form");
var _streamsSchema = require("@kbn/streams-schema");
var _use_kibana = require("../../../../../../hooks/use_kibana");
var _utils = require("../../../utils");
var _config_driven = require("./config_driven");
var _stream_enrichment_state_machine = require("../../../state_management/stream_enrichment_state_machine");
var _selectors = require("../../../state_management/simulation_state_machine/selectors");
var _steps_state_machine = require("../../../state_management/steps_state_machine");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_enrichment/steps/blocks/action/processor_type_selector.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ProcessorTypeSelector = ({
  disabled = false
}) => {
  const {
    core
  } = (0, _use_kibana.useKibana)();
  const getEnrichmentState = (0, _stream_enrichment_state_machine.useGetStreamEnrichmentState)();
  const {
    reset
  } = (0, _reactHookForm.useFormContext)();
  const {
    field,
    fieldState
  } = (0, _reactHookForm.useController)({
    name: 'action',
    rules: {
      required: true
    }
  });
  const processorType = (0, _reactHookForm.useWatch)({
    name: 'action'
  });
  const isWired = (0, _stream_enrichment_state_machine.useStreamEnrichmentSelector)(snapshot => _streamsSchema.Streams.WiredStream.GetResponse.is(snapshot.context.definition));
  const isWithinWhereBlock = (0, _stream_enrichment_state_machine.useStreamEnrichmentSelector)(state => {
    const stepUnderEdit = state.context.stepRefs.find(stepRef => (0, _steps_state_machine.isStepUnderEdit)(stepRef.getSnapshot()));
    return stepUnderEdit ? stepUnderEdit.getSnapshot().context.step.parentId !== null : false;
  });
  const grokCollection = (0, _stream_enrichment_state_machine.useStreamEnrichmentSelector)(state => state.context.grokCollection);

  // To make it possible to clear the selection to enter a new value,
  // keep track of local empty state. As soon as field.value is set, switch back to highlighting
  // the selected option.
  const [localEmpty, setLocalEmpty] = _react.default.useState(false);
  (0, _react.useEffect)(() => {
    if (field.value) {
      setLocalEmpty(false);
    }
  }, [field.value]);
  const handleChange = selectedOptions => {
    if (selectedOptions.length === 0) {
      setLocalEmpty(true);
      return;
    }
    const type = selectedOptions[0].value;
    const formState = (0, _utils.getDefaultFormStateByType)(type, (0, _selectors.selectPreviewRecords)(getEnrichmentState().context.simulatorRef.getSnapshot().context), {
      grokCollection
    });
    reset(formState);
  };
  const groupedOptions = (0, _react.useMemo)(() => getProcessorTypeSelectorOptions(isWired, isWithinWhereBlock), [isWired, isWithinWhereBlock]);
  const selectedOptions = (0, _react.useMemo)(() => {
    const allOptions = groupedOptions.flatMap(group => group.options);
    const selected = allOptions.find(opt => opt.value === field.value);
    return selected ? [selected] : [];
  }, [field.value, groupedOptions]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.typeSelectorLabel', {
      defaultMessage: 'Processor'
    }),
    helpText: getProcessorDescription(core.docLinks, isWired, isWithinWhereBlock)(processorType),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    "data-test-subj": "streamsAppProcessorTypeSelector",
    "aria-label": _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.typeSelectorLabel', {
      defaultMessage: 'Processor'
    }),
    isDisabled: disabled,
    options: groupedOptions,
    isInvalid: fieldState.invalid,
    selectedOptions: localEmpty ? [] : selectedOptions,
    onChange: handleChange,
    fullWidth: true,
    singleSelection: {
      asPlainText: true
    },
    compressed: true,
    placeholder: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.typeSelectorPlaceholder', {
      defaultMessage: 'Grok, Dissect ...'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 7
    }
  }));
};
exports.ProcessorTypeSelector = ProcessorTypeSelector;
const getAvailableProcessors = (isWired, isWithinWhereBlock = false) => ({
  date: {
    type: 'date',
    inputDisplay: 'Date',
    getDocUrl: () => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.streams.streamDetailView.managementTab.enrichment.processor.dateHelpText",
      defaultMessage: "Converts a date to a document timestamp.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 134,
        columnNumber: 7
      }
    })
  },
  dissect: {
    type: 'dissect',
    inputDisplay: 'Dissect',
    getDocUrl: docLinks => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.streams.streamDetailView.managementTab.enrichment.processor.dissectHelpText",
      defaultMessage: "Uses {dissectLink} patterns to extract matches from a field.",
      values: {
        dissectLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": "streamsAppAvailableProcessorsDissectLink",
          external: true,
          target: "_blank",
          href: docLinks.links.ingest.dissect,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 149,
            columnNumber: 13
          }
        }, _i18n.i18n.translate('xpack.streams.availableProcessors.dissectLinkLabel', {
          defaultMessage: 'dissect'
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 144,
        columnNumber: 7
      }
    })
  },
  grok: {
    type: 'grok',
    inputDisplay: 'Grok',
    getDocUrl: docLinks => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.streams.streamDetailView.managementTab.enrichment.processor.grokHelpText",
      defaultMessage: "Uses {grokLink} expressions to extract matches from a field.",
      values: {
        grokLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": "streamsAppAvailableProcessorsGrokLink",
          external: true,
          target: "_blank",
          href: docLinks.links.ingest.grok,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 173,
            columnNumber: 13
          }
        }, _i18n.i18n.translate('xpack.streams.availableProcessors.grokLinkLabel', {
          defaultMessage: 'grok'
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 168,
        columnNumber: 7
      }
    })
  },
  convert: {
    type: 'convert',
    inputDisplay: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.convertInputDisplay', {
      defaultMessage: 'Convert'
    }),
    getDocUrl: docLinks => {
      return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.streams.streamDetailView.managementTab.enrichment.processor.setHelpText",
        defaultMessage: "{convertLink}. For example, you can convert a string to an long.",
        values: {
          convertLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            "data-test-subj": "streamsAppAvailableProcessorsConvertLink",
            external: true,
            target: "_blank",
            href: docLinks.links.ingest.convert,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 203,
              columnNumber: 15
            }
          }, _i18n.i18n.translate('xpack.streams.availableProcessors.setLinkLabel', {
            defaultMessage: 'Converts a field to a different data type'
          }))
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 198,
          columnNumber: 9
        }
      });
    }
  },
  set: {
    type: 'set',
    inputDisplay: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.setInputDisplay', {
      defaultMessage: 'Set'
    }),
    getDocUrl: docLinks => {
      return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.streams.streamDetailView.managementTab.enrichment.processor.setHelpText",
        defaultMessage: "{setLink} If the field already exists, its value will be replaced with the provided one.",
        values: {
          setLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            "data-test-subj": "streamsAppAvailableProcessorsSetLink",
            external: true,
            target: "_blank",
            href: docLinks.links.ingest.set,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 234,
              columnNumber: 15
            }
          }, _i18n.i18n.translate('xpack.streams.availableProcessors.setLinkLabel', {
            defaultMessage: 'Sets one field and associates it with the specified value.'
          }))
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 229,
          columnNumber: 9
        }
      });
    }
  },
  replace: {
    type: 'replace',
    inputDisplay: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.replaceInputDisplay', {
      defaultMessage: 'Replace'
    }),
    getDocUrl: docLinks => {
      return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.streams.streamDetailView.managementTab.enrichment.processor.replaceHelpText",
        defaultMessage: "{replaceLink} that match a regular expression pattern with a replacement string.",
        values: {
          replaceLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            "data-test-subj": "streamsAppAvailableProcessorsReplaceLink",
            external: true,
            target: "_blank",
            href: docLinks.links.ingest.gsub,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 265,
              columnNumber: 15
            }
          }, _i18n.i18n.translate('xpack.streams.availableProcessors.replaceLinkLabel', {
            defaultMessage: 'Replaces parts of a string field.'
          }))
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 260,
          columnNumber: 9
        }
      });
    }
  },
  ..._config_driven.configDrivenProcessors,
  ...(isWired ? {} : {
    manual_ingest_pipeline: {
      type: 'manual_ingest_pipeline',
      inputDisplay: 'Manual pipeline configuration',
      getDocUrl: () => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.streams.streamDetailView.managementTab.enrichment.processor.manualIngestPipelineHelpText",
        defaultMessage: "Specify an array of ingest pipeline processors using JSON.",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 289,
          columnNumber: 13
        }
      })
    }
  }),
  // Remove remove_by_prefix from available processors when inside a where block
  ...(isWithinWhereBlock ? {
    remove_by_prefix: undefined
  } : {})
});
const PROCESSOR_GROUP_MAP = {
  remove: 'removeField',
  remove_by_prefix: 'removeField',
  grok: 'extract',
  dissect: 'extract',
  convert: 'convert',
  date: 'convert',
  replace: 'convert',
  append: 'set',
  set: 'set',
  rename: 'set',
  drop_document: 'other',
  manual_ingest_pipeline: 'other'
};
const getProcessorDescription = (docLinks, isWired, isWithinWhereBlock) => type => {
  var _getAvailableProcesso;
  return (_getAvailableProcesso = getAvailableProcessors(isWired, isWithinWhereBlock)[type]) === null || _getAvailableProcesso === void 0 ? void 0 : _getAvailableProcesso.getDocUrl(docLinks);
};
const getProcessorTypeSelectorOptions = (isWired, isWithinWhereBlock) => {
  const availableProcessors = getAvailableProcessors(isWired, isWithinWhereBlock);

  // Define processor groups
  const groups = {
    removeField: [],
    extract: [],
    convert: [],
    set: [],
    other: []
  };

  // Categorize processors into groups using lookup map
  Object.values(availableProcessors).filter(processor => processor !== undefined).forEach(({
    type,
    inputDisplay
  }) => {
    const option = {
      label: inputDisplay,
      value: type
    };
    const groupKey = PROCESSOR_GROUP_MAP[type] || 'other';
    groups[groupKey].push(option);
  });
  const result = [];
  if (groups.removeField.length > 0) {
    result.push({
      label: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.removeFieldGroup', {
        defaultMessage: 'Remove field'
      }),
      options: groups.removeField
    });
  }
  if (groups.extract.length > 0) {
    result.push({
      label: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.extractGroup', {
        defaultMessage: 'Extract'
      }),
      options: groups.extract
    });
  }
  if (groups.convert.length > 0) {
    result.push({
      label: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.convertGroup', {
        defaultMessage: 'Convert'
      }),
      options: groups.convert
    });
  }
  if (groups.set.length > 0) {
    result.push({
      label: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.setGroup', {
        defaultMessage: 'Set'
      }),
      options: groups.set
    });
  }
  if (groups.other.length > 0) {
    result.push({
      label: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.otherGroup', {
        defaultMessage: 'Other'
      }),
      options: groups.other
    });
  }
  return result;
};