"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProcessorMetricBadges = exports.ProcessorErrors = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _useToggle = _interopRequireDefault(require("react-use/lib/useToggle"));
var _react2 = require("@emotion/react");
var _formatters = require("../../../../../../util/formatters");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_enrichment/steps/blocks/action/processor_metrics.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/* eslint-disable @typescript-eslint/naming-convention */
const formatter = (0, _formatters.getPercentageFormatter)();
const messageStyles = (0, _react2.css)`
  overflow-wrap: anywhere;
`;
const ProcessorErrorMessage = ({
  message
}) => {
  const [expanded, toggleExpanded] = (0, _useToggle.default)(false);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const CLAMP_LINES = 5;
  const LONG_MESSAGE_CHARACTER_THRESHOLD = 300;
  const shouldTruncate = message.length > LONG_MESSAGE_CHARACTER_THRESHOLD;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, expanded ? /*#__PURE__*/_react.default.createElement("div", {
    css: messageStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 9
    }
  }, message) : /*#__PURE__*/_react.default.createElement(_eui.EuiTextBlockTruncate, {
    lines: CLAMP_LINES,
    cloneElement: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    css: messageStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 11
    }
  }, message)), shouldTruncate && /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: toggleExpanded,
    "data-test-subj": "streamsAppProcessorErrorMessageToggle",
    css: (0, _react2.css)`
            padding-top: ${euiTheme.size.xs};
          `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 9
    }
  }, expanded ? _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processorErrors.message.showLess', {
    defaultMessage: 'Show less'
  }) : _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processorErrors.message.showMore', {
    defaultMessage: 'Show full message'
  })));
};
const ProcessorMetricBadges = ({
  detected_fields,
  failed_rate,
  skipped_rate,
  parsed_rate
}) => {
  const detectedFieldsCount = detected_fields.length;
  const parsedRate = parsed_rate > 0 ? formatter.format(parsed_rate) : null;
  const skippedRate = skipped_rate > 0 ? formatter.format(skipped_rate) : null;
  const failedRate = failed_rate > 0 ? formatter.format(failed_rate) : null;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 5
    }
  }, parsedRate && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: _i18n.i18n.translate('xpack.streams.processorMetricBadges.euiBadge.parsedRate', {
      defaultMessage: '{parsedRate} of the sampled documents were successfully parsed by this processor',
      values: {
        parsedRate
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "success",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "check",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 19
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 17
    }
  }, parsedRate))))), failedRate && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: _i18n.i18n.translate('xpack.streams.processorMetricBadges.euiBadge.failedRate', {
      defaultMessage: '{failedRate} of the sampled documents were not parsed due to an error',
      values: {
        failedRate
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    tabIndex: 0,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "danger",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "cross",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 21
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 19
    }
  }, failedRate)))))), skippedRate && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: _i18n.i18n.translate('xpack.streams.processorMetricBadges.euiBadge.skippedRate', {
      defaultMessage: '{skippedRate} of the sampled documents were skipped due to the set condition',
      values: {
        skippedRate
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "default",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 13
    }
  }, skippedRate))), detectedFieldsCount > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow",
    title: _i18n.i18n.translate('xpack.streams.processorMetricBadges.euiBadge.detectedFields', {
      defaultMessage: '{detectedFieldsCount, plural, one {# field was parsed on the sampled documents: } other {# fields were parsed on the sampled documents:\n}}{detectedFields}',
      values: {
        detectedFieldsCount,
        detectedFields: detected_fields.join('\n')
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.streams.processorMetricBadges.fieldsBadgeLabel', {
    defaultMessage: '{detectedFieldsCount, plural, one {# field } other {# fields}}',
    values: {
      detectedFieldsCount
    }
  }))));
};
exports.ProcessorMetricBadges = ProcessorMetricBadges;
const errorTitle = _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processorErrors.title', {
  defaultMessage: "Processor configuration invalid or doesn't match."
});
const ProcessorErrors = ({
  metrics
}) => {
  const {
    errors,
    parsed_rate
  } = metrics;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [isErrorListExpanded, toggleErrorListExpanded] = (0, _useToggle.default)(false);
  const visibleErrors = isErrorListExpanded ? errors : errors.slice(0, 2);
  const remainingCount = errors.length - 2;
  const shouldDisplayErrorToggle = remainingCount > 0;
  const getCalloutProps = type => {
    const isWarningError = type === 'generic_processor_failure' && parsed_rate > 0;
    return {
      color: isWarningError ? 'warning' : 'danger'
    };
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    direction: "column",
    css: (0, _react2.css)`
          margin-top: ${euiTheme.size.m};
        `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 7
    }
  }, visibleErrors.map((error, id) => /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, (0, _extends2.default)({
    key: id
  }, getCalloutProps(error.type), {
    size: "s",
    title: errorTitle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(ProcessorErrorMessage, {
    message: error.message,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 13
    }
  })))), shouldDisplayErrorToggle && !isErrorListExpanded && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "streamsAppProcessorErrorsShowMoreButton",
    onClick: toggleErrorListExpanded,
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processorErrors.showMore', {
    defaultMessage: 'Show {remainingCount} similar errors...',
    values: {
      remainingCount
    }
  })), shouldDisplayErrorToggle && isErrorListExpanded && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "streamsAppProcessorErrorsShowLessButton",
    onClick: toggleErrorListExpanded,
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 226,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processorErrors.showLess', {
    defaultMessage: 'Show less errors'
  })));
};
exports.ProcessorErrors = ProcessorErrors;