"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GrokPatternsEditor = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _reactHookForm = require("react-hook-form");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _grokUi = require("@kbn/grok-ui");
var _sharedUxUtility = require("@kbn/shared-ux-utility");
var _react2 = require("@emotion/react");
var _lodash = require("lodash");
var _stream_enrichment_state_machine = require("../../../../state_management/stream_enrichment_state_machine");
var _sortable_list = require("../../../../sortable_list");
var _use_ai_features = require("../../../../../../../hooks/use_ai_features");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_enrichment/steps/blocks/action/grok/grok_patterns_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const GrokPatternAISuggestions = (0, _sharedUxUtility.dynamic)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./grok_pattern_suggestion'))).then(mod => ({
  default: mod.GrokPatternAISuggestions
})));
const GrokPatternsEditor = () => {
  var _errors$patterns, _errors$patterns$root;
  const {
    formState: {
      errors
    },
    setValue
  } = (0, _reactHookForm.useFormContext)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const aiFeatures = (0, _use_ai_features.useAIFeatures)();
  const grokCollection = (0, _stream_enrichment_state_machine.useStreamEnrichmentSelector)(machineState => machineState.context.grokCollection);
  const {
    fields,
    append,
    remove,
    move
  } = (0, _reactHookForm.useFieldArray)({
    name: 'patterns',
    rules: {
      minLength: 1,
      validate: expressions => {
        if (expressions.every(expression => (0, _lodash.isEmpty)(expression.getExpression()))) {
          return _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.grokEditorRequiredError', {
            defaultMessage: 'Empty patterns are not allowed.'
          });
        }
        return true;
      }
    }
  });
  const handlePatternDrag = ({
    source,
    destination
  }) => {
    if (source && destination) {
      move(source.index, destination.index);
    }
  };
  const handleAddPattern = () => {
    append(new _grokUi.DraftGrokExpression(grokCollection, ''));
  };
  const getRemovePatternHandler = id => fields.length > 1 ? () => remove(id) : null;
  const handlePatternChange = (expression, idx) => {
    setValue(`patterns.${idx}`, expression, {
      shouldValidate: true
    });
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.grokEditorLabel', {
      defaultMessage: 'Grok patterns'
    }),
    css: (0, _react2.css)`
          margin-bottom: ${euiTheme.size.s};
        `,
    isInvalid: Boolean(errors.patterns),
    error: (_errors$patterns = errors.patterns) === null || _errors$patterns === void 0 ? void 0 : (_errors$patterns$root = _errors$patterns.root) === null || _errors$patterns$root === void 0 ? void 0 : _errors$patterns$root.message,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued",
    paddingSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_sortable_list.SortableList, {
    onDragItem: handlePatternDrag,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 11
    }
  }, fields.map((field, idx) => /*#__PURE__*/_react.default.createElement(DraggablePatternInput, {
    key: field.id,
    draftGrokExpression: field,
    idx: idx,
    onRemove: getRemovePatternHandler(idx),
    grokCollection: grokCollection,
    onChange: expression => handlePatternChange(expression, idx),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 15
    }
  }))))), aiFeatures ? /*#__PURE__*/_react.default.createElement(GrokPatternAISuggestions, {
    aiFeatures: aiFeatures,
    grokCollection: grokCollection,
    setValue: setValue,
    onAddPattern: handleAddPattern,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 9
    }
  }) : /*#__PURE__*/_react.default.createElement(AddPatternButton, {
    onClick: handleAddPattern,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 9
    }
  }));
};
exports.GrokPatternsEditor = GrokPatternsEditor;
const AddPatternButton = props => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, (0, _extends2.default)({
    "data-test-subj": "streamsAppGrokPatternsEditorAddPatternButton",
    flush: "left",
    size: "s"
  }, props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 5
    }
  }), _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.grokEditor.addPattern', {
    defaultMessage: 'Add pattern'
  }));
};
const DraggablePatternInput = ({
  draftGrokExpression,
  idx,
  grokCollection,
  onChange,
  onRemove
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDraggable, {
    index: idx,
    spacing: "m",
    draggableId: draftGrokExpression.id,
    hasInteractiveChildren: true,
    customDragHandle: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 5
    }
  }, provided => /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    responsive: false,
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, (0, _extends2.default)({
    color: "transparent",
    paddingSize: "s"
  }, provided.dragHandleProps, {
    "aria-label": _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.grokEditor.dragHandleLabel', {
      defaultMessage: 'Drag Handle'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "grab",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      minWidth: 0
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_grokUi.Expression, {
    draftGrokExpression: draftGrokExpression,
    grokCollection: grokCollection,
    dataTestSubj: "streamsAppPatternExpression",
    onChange: onChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 15
    }
  })), onRemove && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "streamsAppDraggablePatternInputButton",
    iconType: "minusInCircle",
    color: "danger",
    onClick: () => onRemove(idx),
    "aria-label": _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.grokEditor.removePattern', {
      defaultMessage: 'Remove grok pattern'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 15
    }
  }))));
};