"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AdditionalChargesCallout = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _use_kibana = require("../../../../../../../hooks/use_kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_enrichment/steps/blocks/action/grok/additional_charges_callout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const AdditionalChargesCallout = ({
  aiFeatures
}) => {
  const {
    core: {
      docLinks
    }
  } = (0, _use_kibana.useKibana)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    onDismiss: () => aiFeatures.acknowledgeAdditionalCharges(true),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 24,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.streams.streamDetailView.managementTab.enrichment.processorFlyout.managedConnectorTooltip",
    defaultMessage: "Elastic Managed LLM is the new default for generating patterns and incurs <costLink>additional charges</costLink>. Other LLM connectors remain available. <learnMoreLink>Learn more</learnMoreLink>",
    values: {
      costLink: (...chunks) => {
        var _docLinks$links, _docLinks$links$obser;
        return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: docLinks === null || docLinks === void 0 ? void 0 : (_docLinks$links = docLinks.links) === null || _docLinks$links === void 0 ? void 0 : (_docLinks$links$obser = _docLinks$links.observability) === null || _docLinks$links$obser === void 0 ? void 0 : _docLinks$links$obser.elasticManagedLlmUsageCost,
          target: "_blank",
          rel: "noopener noreferrer",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 30,
            columnNumber: 13
          }
        }, chunks);
      },
      learnMoreLink: (...chunks) => {
        var _docLinks$links2, _docLinks$links2$obse;
        return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: docLinks === null || docLinks === void 0 ? void 0 : (_docLinks$links2 = docLinks.links) === null || _docLinks$links2 === void 0 ? void 0 : (_docLinks$links2$obse = _docLinks$links2.observability) === null || _docLinks$links2$obse === void 0 ? void 0 : _docLinks$links2$obse.elasticManagedLlm,
          target: "_blank",
          rel: "noopener noreferrer",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 39,
            columnNumber: 13
          }
        }, chunks);
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 25,
      columnNumber: 7
    }
  }));
};
exports.AdditionalChargesCallout = AdditionalChargesCallout;