"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DissectPatternAISuggestions = void 0;
exports.DissectPatternSuggestion = DissectPatternSuggestion;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _reactHookForm = require("react-hook-form");
var _use_stream_detail = require("../../../../../../../hooks/use_stream_detail");
var _selectors = require("../../../../state_management/simulation_state_machine/selectors");
var _stream_enrichment_state_machine = require("../../../../state_management/stream_enrichment_state_machine");
var _additional_charges_callout = require("../grok/additional_charges_callout");
var _generate_suggestions_button = require("../../../../../stream_detail_routing/review_suggestions_form/generate_suggestions_button");
var _use_dissect_pattern_suggestion = require("./use_dissect_pattern_suggestion");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_enrichment/steps/blocks/action/dissect/dissect_pattern_suggestion.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DissectPatternAISuggestions = ({
  aiFeatures,
  setValue
}) => {
  const {
    definition: {
      stream
    }
  } = (0, _use_stream_detail.useStreamDetail)();
  const previewDocuments = (0, _stream_enrichment_state_machine.useSimulatorSelector)(snapshot => (0, _selectors.selectPreviewRecords)(snapshot.context));
  const [suggestionsState, refreshSuggestions] = (0, _use_dissect_pattern_suggestion.useDissectPatternSuggestion)();
  const fieldValue = (0, _reactHookForm.useWatch)({
    name: 'from'
  });
  const isValidField = (0, _react.useMemo)(() => {
    return Boolean(fieldValue && previewDocuments.some(sample => sample[fieldValue] && typeof sample[fieldValue] === 'string'));
  }, [previewDocuments, fieldValue]);
  if (suggestionsState.value) {
    return /*#__PURE__*/_react.default.createElement(DissectPatternSuggestion, {
      dissectProcessor: suggestionsState.value.dissectProcessor,
      simulationResult: suggestionsState.value.simulationResult,
      onAccept: () => {
        if (suggestionsState.value) {
          setValue('pattern', suggestionsState.value.dissectProcessor.pattern, {
            shouldValidate: true
          });
          // Set append_separator if the processor uses it
          if (suggestionsState.value.dissectProcessor.processor.dissect.append_separator) {
            setValue('append_separator', suggestionsState.value.dissectProcessor.processor.dissect.append_separator, {
              shouldValidate: true
            });
          }
        }
        refreshSuggestions(null);
      },
      onDismiss: () => refreshSuggestions(null),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 62,
        columnNumber: 7
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "l",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 7
    }
  }, aiFeatures.enabled && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_generate_suggestions_button.GenerateSuggestionButton, {
    aiFeatures: aiFeatures,
    onClick: connectorId => {
      refreshSuggestions({
        connectorId,
        streamName: stream.name,
        fieldName: fieldValue
      });
    },
    isLoading: suggestionsState.loading,
    isDisabled: !isValidField,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.dissectProcessorFlyout.refreshSuggestions', {
    defaultMessage: 'Generate pattern'
  })))), aiFeatures && aiFeatures.enabled && aiFeatures.isManagedAIConnector && !aiFeatures.hasAcknowledgedAdditionalCharges && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_additional_charges_callout.AdditionalChargesCallout, {
    aiFeatures: aiFeatures,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 13
    }
  })));
};
exports.DissectPatternAISuggestions = DissectPatternAISuggestions;
function DissectPatternSuggestion({
  dissectProcessor,
  simulationResult,
  onAccept,
  onDismiss
}) {
  const processorMetrics = simulationResult.processors_metrics['dissect-processor'];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    iconType: "sparkles",
    title: dissectProcessor.description || 'Dissect pattern suggestion',
    color: "primary",
    size: "s",
    onDismiss: onDismiss,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    paddingSize: "none",
    language: "text",
    transparentBackground: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 7
    }
  }, dissectProcessor.pattern), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    responsive: false,
    wrap: false,
    alignItems: "flexStart",
    direction: "column",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadgeGroup, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.dissectPatternSuggestion.matchRateBadge', {
    defaultMessage: '{percentage}% Matched',
    values: {
      percentage: (processorMetrics.parsed_rate * 100).toFixed()
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.dissectPatternSuggestion.fieldCountBadge', {
    defaultMessage: '{count} Fields',
    values: {
      count: processorMetrics.detected_fields.length
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: "check",
    onClick: onAccept,
    color: "primary",
    size: "s",
    fill: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.dissectPatternSuggestion.acceptButton', {
    defaultMessage: 'Accept'
  })))));
}