"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DissectPatternDefinition = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactHookForm = require("react-hook-form");
var _eui = require("@elastic/eui");
var _codeEditor = require("@kbn/code-editor");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _sharedUxUtility = require("@kbn/shared-ux-utility");
var _use_kibana = require("../../../../../../../hooks/use_kibana");
var _use_ai_features = require("../../../../../../../hooks/use_ai_features");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_enrichment/steps/blocks/action/dissect/dissect_pattern_definition.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DissectPatternAISuggestions = (0, _sharedUxUtility.dynamic)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./dissect_pattern_suggestion'))).then(mod => ({
  default: mod.DissectPatternAISuggestions
})));
const DissectPatternDefinition = () => {
  const {
    core
  } = (0, _use_kibana.useKibana)();
  const esDocUrl = core.docLinks.links.ingest.dissectKeyModifiers;
  const aiFeatures = (0, _use_ai_features.useAIFeatures)();
  const {
    setValue
  } = (0, _reactHookForm.useFormContext)();
  const {
    field,
    fieldState
  } = (0, _reactHookForm.useController)({
    name: 'pattern',
    rules: {
      required: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.dissectPatternRequiredError', {
        defaultMessage: 'A pattern is required.'
      })
    }
  });
  const {
    invalid,
    error
  } = fieldState;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.dissectPatternDefinitionsLabel', {
      defaultMessage: 'Pattern'
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.streams.streamDetailView.managementTab.enrichment.processor.dissectPatternDefinitionsHelpText",
      defaultMessage: "Pattern used to dissect the specified field. The pattern is defined by the parts of the string to discard. Use a {keyModifier} to alter the dissection behavior.",
      values: {
        keyModifier: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": "streamsAppDissectPatternDefinitionKeyModifierLink",
          target: "_blank",
          external: true,
          href: esDocUrl,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 56,
            columnNumber: 17
          }
        }, _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.dissectPatternDefinitionsLink', {
          defaultMessage: 'key modifier'
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 51,
        columnNumber: 11
      }
    }),
    isInvalid: invalid,
    error: error === null || error === void 0 ? void 0 : error.message,
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_codeEditor.CodeEditor, {
    value: serialize(field.value),
    onChange: value => field.onChange(deserialize(value)),
    languageId: "text",
    height: 75,
    options: {
      automaticLayout: true,
      minimap: {
        enabled: false
      }
    },
    "aria-label": _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.dissectPatternDefinitionsAriaLabel', {
      defaultMessage: 'Pattern editor'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 9
    }
  })), aiFeatures && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(DissectPatternAISuggestions, {
    aiFeatures: aiFeatures,
    setValue: setValue,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 11
    }
  })));
};
exports.DissectPatternDefinition = DissectPatternDefinition;
const serialize = input => {
  if (typeof input === 'string') {
    const s = JSON.stringify(input);
    return s.slice(1, s.length - 1);
  }
  return input;
};
const deserialize = input => {
  if (typeof input === 'string') {
    try {
      return JSON.parse(`"${input}"`);
    } catch (e) {
      return input;
    }
  }
};