"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DateFormatsField = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _reactHookForm = require("react-hook-form");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _lodash = require("lodash");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_enrichment/steps/blocks/action/date/date_formats_field.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const DateFormatsField = ({
  onGenerate
}) => {
  const {
    field,
    fieldState
  } = (0, _reactHookForm.useController)({
    name: 'formats',
    rules: {
      required: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.dateFormatsRequiredError', {
        defaultMessage: 'A value for format is required.'
      })
    }
  });
  const fieldName = (0, _reactHookForm.useWatch)({
    name: 'from'
  });
  const handleChange = options => {
    field.onChange(options.map(option => option.label));
  };
  const handleCreateOption = value => {
    field.onChange([...field.value, value]);
  };
  const {
    invalid,
    error
  } = fieldState;
  const {
    ref,
    ...inputProps
  } = field;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement("span", {
      css: {
        alignContent: 'flex-end',
        height: '100%',
        display: 'inline-block'
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 44,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.dateFormatsLabel', {
      defaultMessage: 'Format'
    })),
    labelAppend: onGenerate ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "xs",
      onClick: onGenerate,
      iconType: "refresh",
      iconSide: "left",
      isDisabled: (0, _lodash.isEmpty)(fieldName),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 53,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.streams.streamDetailView.managementTab.enrichment.processor.dateFormatsGenerateSuggestions",
      defaultMessage: "Generate suggestions",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 60,
        columnNumber: 13
      }
    })) : undefined,
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.streams.streamDetailView.managementTab.enrichment.processor.dateFormatsHelpText",
      defaultMessage: "Expected date format. Accepts a Java time pattern, ISO8601, UNIX, UNIX_MS, or TAI64N format.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 68,
        columnNumber: 9
      }
    }),
    fullWidth: true,
    isInvalid: invalid,
    error: error === null || error === void 0 ? void 0 : error.message,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, (0, _extends2.default)({}, inputProps, {
    "data-test-subj": "input",
    fullWidth: true,
    compressed: true,
    inputRef: ref,
    isInvalid: invalid,
    noSuggestions: true,
    onCreateOption: handleCreateOption,
    onChange: handleChange,
    placeholder: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.dateFormatsPlaceholder', {
      defaultMessage: 'Type and then hit "ENTER"'
    }),
    selectedOptions: field.value.map(label => ({
      label
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 7
    }
  })));
};
exports.DateFormatsField = DateFormatsField;