"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConvertTypeSelector = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactHookForm = require("react-hook-form");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _formats = require("@kbn/streamlang/types/formats");
var _reactField = require("@kbn/react-field");
var _lodash = require("lodash");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_enrichment/steps/blocks/action/convert/type_selector.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const typeSelectorOptions = _formats.convertTypes.map(type => ({
  value: type,
  inputDisplay: /*#__PURE__*/_react.default.createElement(_reactField.FieldNameWithIcon, {
    name: (0, _lodash.capitalize)(type),
    type: type,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 19,
      columnNumber: 17
    }
  })
}));
const ConvertTypeSelector = () => {
  const {
    field
  } = (0, _reactHookForm.useController)({
    name: 'type'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.convertTypeLabel', {
      defaultMessage: 'Type'
    }),
    helpText: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.convertTypeHelpText', {
      defaultMessage: 'Field data type for the output.'
    }),
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    "data-test-subj": "streamsAppConvertTypeSelector",
    onChange: field.onChange,
    valueOfSelected: field.value,
    options: typeSelectorOptions,
    fullWidth: true,
    "aria-label": _i18n.i18n.translate('xpack.streams.fieldFormType.typeSelectAriaLabel', {
      defaultMessage: 'Field type'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 7
    }
  }));
};
exports.ConvertTypeSelector = ConvertTypeSelector;