"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TargetFieldSelector = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _reactHookForm = require("react-hook-form");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _streamlang = require("@kbn/streamlang");
var _steps_state_machine = require("../../../../state_management/steps_state_machine");
var _stream_enrichment_state_machine = require("../../../../state_management/stream_enrichment_state_machine");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_enrichment/steps/blocks/action/convert/target_field.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const TargetFieldSelector = () => {
  var _errors$to;
  const {
    register,
    formState: {
      errors
    }
  } = (0, _reactHookForm.useFormContext)();
  const isWithinWhereBlock = (0, _stream_enrichment_state_machine.useStreamEnrichmentSelector)(state => {
    const stepUnderEdit = state.context.stepRefs.find(stepRef => (0, _steps_state_machine.isStepUnderEdit)(stepRef.getSnapshot()));
    return stepUnderEdit ? stepUnderEdit.getSnapshot().context.step.parentId !== null : false;
  });
  const {
    ref,
    ...inputProps
  } = register('to', {
    validate: (value, formValues) => {
      var _formValues$from;
      const hasTargetField = Boolean(value === null || value === void 0 ? void 0 : value.trim());
      const isEqualToSourceField = (value === null || value === void 0 ? void 0 : value.trim()) === ((_formValues$from = formValues.from) === null || _formValues$from === void 0 ? void 0 : _formValues$from.trim());
      if (isWithinWhereBlock) {
        if (!hasTargetField) {
          return _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.convertTargetFieldRequiredInWhereBlock', {
            defaultMessage: 'For a convert processor within a where block, the target field is required. Either set this field or move the processor at the root level.'
          });
        }
        if (isEqualToSourceField) {
          return _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.convertTargetFieldCannotBeEqualToSourceFieldInWhereBlock', {
            defaultMessage: 'The target field cannot be the same as the source field in a where block.'
          });
        }
      }
      if ('where' in formValues && !(0, _streamlang.isAlwaysCondition)(formValues.where)) {
        if (!hasTargetField) {
          return _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.convertTargetFieldRequiredWithCondition', {
            defaultMessage: 'For a convert processor with a defined condition, the target field is required. Either set this field or remove the processor condition.'
          });
        }
        if (isEqualToSourceField) {
          return _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.convertTargetFieldCannotBeEqualToSourceFieldWithCondition', {
            defaultMessage: 'The target field cannot be the same as the source field when a condition is defined.'
          });
        }
      }
      return true;
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.targetFieldLabel', {
      defaultMessage: 'Target field'
    }),
    helpText: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.targetFieldHelpText', {
      defaultMessage: 'Output field. If empty, the input field is updated in place.'
    }),
    isInvalid: Boolean(errors.to),
    error: (_errors$to = errors.to) === null || _errors$to === void 0 ? void 0 : _errors$to.message,
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, (0, _extends2.default)({
    isInvalid: Boolean(errors.to)
  }, inputProps, {
    inputRef: ref,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 7
    }
  })));
};
exports.TargetFieldSelector = TargetFieldSelector;