"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.removeByPrefixProcessorConfig = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _utils = require("../utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_enrichment/steps/blocks/action/config_driven/configs/remove_by_prefix.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const defaultFormState = {
  action: 'remove_by_prefix',
  from: '',
  ignore_failure: true
};
const fieldOptions = {
  fieldKey: 'from',
  fieldHelpText: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.removeByPrefixFieldHelpText', {
    defaultMessage: 'The field to be removed. All nested fields (field.*) will also be removed.'
  }),
  includeCondition: false,
  includeIgnoreFailures: true,
  includeIgnoreMissing: false
};
const fieldConfigurations = [];
const removeByPrefixProcessorConfig = exports.removeByPrefixProcessorConfig = {
  type: 'remove_by_prefix',
  inputDisplay: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.removeByPrefixInputDisplay', {
    defaultMessage: 'Remove by prefix'
  }),
  getDocUrl: docLinks => {
    return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.streams.streamDetailView.managementTab.enrichment.processor.removeByPrefixHelpText",
      defaultMessage: "{removeByPrefixLink} The processor removes the field and all its nested fields (field.*).",
      values: {
        removeByPrefixLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": "streamsAppAvailableProcessorsRemoveByPrefixLink",
          external: true,
          target: "_blank",
          href: docLinks.links.ingest.remove,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 62,
            columnNumber: 13
          }
        }, _i18n.i18n.translate('xpack.streams.availableProcessors.removeByPrefixLinkLabel', {
          defaultMessage: 'Removes a field and all nested fields.'
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 57,
        columnNumber: 7
      }
    });
  },
  defaultFormState,
  convertFormStateToConfig: (0, _utils.getConvertFormStateToConfig)(fieldConfigurations, fieldOptions),
  convertProcessorToFormState: (0, _utils.getConvertProcessorToFormState)(defaultFormState),
  fieldConfigurations,
  fieldOptions
};