"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfigDrivenProcessorFields = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _ = require("..");
var _processor_field_selector = require("../../processor_field_selector");
var _optional_fields_accordion = require("../../optional_fields_accordion");
var _ignore_toggles = require("../../ignore_toggles");
var _text_field = require("./text_field");
var _boolean_field = require("./boolean_field");
var _array_field = require("./array_field");
var _processor_condition_editor = require("../../processor_condition_editor");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_enrichment/steps/blocks/action/config_driven/components/fields.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ConfigDrivenProcessorFields = ({
  type
}) => {
  const processor = _.configDrivenProcessors[type];

  // This shouldn't happen.
  if (!processor) {
    return null;
  }
  const optionalFields = processor.fieldConfigurations.filter(fieldConfiguration => !fieldConfiguration.required);
  const hasOptionalContent = optionalFields.length > 0 || processor.fieldOptions.includeCondition;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_processor_field_selector.ProcessorFieldSelector, {
    helpText: processor.fieldOptions.fieldHelpText,
    fieldKey: processor.fieldOptions.fieldKey,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 7
    }
  }), processor.fieldConfigurations.filter(fieldConfiguration => fieldConfiguration.required).map((fieldConfiguration, id) => /*#__PURE__*/_react.default.createElement(FieldComponentByConfig, {
    key: id,
    fieldConfiguration: fieldConfiguration,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 7
    }
  }), hasOptionalContent && /*#__PURE__*/_react.default.createElement(_optional_fields_accordion.FieldsAccordion, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 9
    }
  }, optionalFields.map((fieldConfiguration, id) => /*#__PURE__*/_react.default.createElement(FieldComponentByConfig, {
    key: id,
    fieldConfiguration: fieldConfiguration,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 13
    }
  })), processor.fieldOptions.includeCondition && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_processor_condition_editor.ProcessorConditionEditor, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 7
    }
  }), processor.fieldOptions.includeIgnoreFailures && /*#__PURE__*/_react.default.createElement(_ignore_toggles.IgnoreFailureToggle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 56
    }
  }), processor.fieldOptions.includeIgnoreMissing && /*#__PURE__*/_react.default.createElement(_ignore_toggles.IgnoreMissingToggle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 55
    }
  }));
};
exports.ConfigDrivenProcessorFields = ConfigDrivenProcessorFields;
const FieldComponentByConfig = ({
  fieldConfiguration
}) => {
  switch (fieldConfiguration.type) {
    case 'string':
      return /*#__PURE__*/_react.default.createElement(_text_field.TextField, {
        fieldConfiguration: fieldConfiguration,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 73,
          columnNumber: 14
        }
      });
    case 'array':
      return /*#__PURE__*/_react.default.createElement(_array_field.ArrayField, {
        fieldConfiguration: fieldConfiguration,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 75,
          columnNumber: 14
        }
      });
    case 'boolean':
      return /*#__PURE__*/_react.default.createElement(_boolean_field.BooleanField, {
        fieldConfiguration: fieldConfiguration,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 77,
          columnNumber: 14
        }
      });
  }
};