"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createUrlInitializerActor = createUrlInitializerActor;
exports.createUrlSyncAction = createUrlSyncAction;
var _xstate = require("xstate5");
var _public = require("@kbn/kibana-utils-plugin/public");
var _common = require("../../../../../../common/url_schema/common");
var _url_schema = require("../../../../../../common/url_schema");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createUrlInitializerActor({
  core,
  urlStateStorageContainer
}) {
  return (0, _xstate.fromCallback)(({
    sendBack
  }) => {
    var _urlStateStorageConta;
    const urlStateValues = (_urlStateStorageConta = urlStateStorageContainer.get(_url_schema.ENRICHMENT_URL_STATE_KEY)) !== null && _urlStateStorageConta !== void 0 ? _urlStateStorageConta : undefined;
    const persistedCustomSamplesSources = retrievePersistedCustomSamplesSources();
    if (!urlStateValues) {
      return sendBack({
        type: 'url.initialized',
        urlState: {
          ..._utils.defaultEnrichmentUrlState,
          dataSources: getDataSourcesWithDefault(Object.values(persistedCustomSamplesSources) // Add new custom samples data sources not existing in the url state
          )
        }
      });
    }
    const urlState = _url_schema.enrichmentUrlSchema.safeParse(urlStateValues);
    if (urlState.success) {
      // Restore persisted custom samples documents for existing custom samples data sources
      urlState.data.dataSources.forEach(source => {
        if (source.type === 'custom-samples' && source.storageKey && source.storageKey in persistedCustomSamplesSources) {
          source.documents = persistedCustomSamplesSources[source.storageKey].documents;
          delete persistedCustomSamplesSources[source.storageKey];
        }
      });

      // Add new custom samples data sources not existing in the url state
      Object.keys(persistedCustomSamplesSources).forEach(key => {
        urlState.data.dataSources.push(persistedCustomSamplesSources[key]);
      });

      // Always add default latest samples data source
      if (!hasDefaultLatestSamplesDataSource(urlState.data.dataSources)) {
        const dataSourcesWithDefault = getDataSourcesWithDefault(urlState.data.dataSources);
        urlState.data.dataSources = dataSourcesWithDefault;
      }
      sendBack({
        type: 'url.initialized',
        urlState: urlState.data
      });
    } else {
      (0, _public.withNotifyOnErrors)(core.notifications.toasts).onGetError(new Error('The default state will be used as fallback.'));
      sendBack({
        type: 'url.initialized',
        urlState: _utils.defaultEnrichmentUrlState
      });
    }
  });
}
const hasDefaultLatestSamplesDataSource = dataSources => {
  return dataSources.some(dataSource => dataSource.type === 'latest-samples');
};
const getDataSourcesWithDefault = dataSources => {
  const isLatestSamplesDataSourceEnabled = dataSources.every(dataSource => !dataSource.enabled);
  dataSources.unshift({
    ..._utils.defaultLatestSamplesDataSource,
    enabled: isLatestSamplesDataSourceEnabled
  });
  return dataSources;
};
const retrievePersistedCustomSamplesSources = () => {
  const storedSourcesKeys = Object.keys(sessionStorage).filter(key => key.startsWith(_common.CUSTOM_SAMPLES_DATA_SOURCE_STORAGE_KEY_PREFIX));
  const sources = {};
  storedSourcesKeys.forEach(key => {
    const dataSource = sessionStorage.getItem(key);
    if (dataSource) {
      const parsedDataSource = JSON.parse(dataSource);
      parsedDataSource.enabled = false;
      sources[key] = {
        ...parsedDataSource,
        documents: []
      };
    }
  });
  return sources;
};
function createUrlSyncAction({
  urlStateStorageContainer
}) {
  return ({
    context
  }) => {
    urlStateStorageContainer.set(_url_schema.ENRICHMENT_URL_STATE_KEY, context.urlState, {
      replace: true
    });
  };
}