"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SimulationPlayground = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _processor_outcome_preview = require("./processor_outcome_preview");
var _stream_enrichment_state_machine = require("./state_management/stream_enrichment_state_machine");
var _detected_fields_editor = require("./detected_fields_editor");
var _data_sources_controls = require("./data_sources_controls");
var _utils = require("./state_management/stream_enrichment_state_machine/utils");
var _data_source_state_machine = require("./state_management/data_source_state_machine");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_enrichment/simulation_playground.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const SimulationPlayground = ({
  schemaEditorFields
}) => {
  const {
    refreshSimulation,
    viewSimulationPreviewData,
    viewSimulationDetectedFields
  } = (0, _stream_enrichment_state_machine.useStreamEnrichmentEvents)();
  const isViewingDataPreview = (0, _stream_enrichment_state_machine.useStreamEnrichmentSelector)(state => state.matches({
    ready: {
      enrichment: {
        displayingSimulation: 'viewDataPreview'
      }
    }
  }));
  const isViewingDetectedFields = (0, _stream_enrichment_state_machine.useStreamEnrichmentSelector)(state => state.matches({
    ready: {
      enrichment: {
        displayingSimulation: 'viewDetectedFields'
      }
    }
  }));
  const activeDataSourceRef = (0, _stream_enrichment_state_machine.useStreamEnrichmentSelector)(state => (0, _utils.getActiveDataSourceRef)(state.context.dataSourcesRefs));
  const isDataSourceLoading = (0, _data_source_state_machine.useDataSourceSelector)(activeDataSourceRef, state => state ? state.matches({
    enabled: 'loadingData'
  }) : false);
  const detectedFields = (0, _stream_enrichment_state_machine.useSimulatorSelector)(state => state.context.detectedSchemaFields);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    bottomBorder: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    isSelected: isViewingDataPreview,
    onClick: viewSimulationPreviewData,
    append: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: "refresh",
      onClick: refreshSimulation,
      isLoading: isDataSourceLoading,
      "aria-label": _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.simulationPlayground.refreshPreviewAriaLabel', {
        defaultMessage: 'Refresh data preview'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 71,
        columnNumber: 19
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.simulationPlayground.dataPreview', {
    defaultMessage: 'Data preview'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    isSelected: isViewingDetectedFields,
    onClick: viewSimulationDetectedFields,
    append: detectedFields.length > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 92,
        columnNumber: 21
      }
    }, detectedFields.length) : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.simulationPlayground.detectedFields', {
    defaultMessage: 'Modified fields'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_data_sources_controls.DataSourcesControls, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(ProgressBar, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 7
    }
  }), isViewingDataPreview && /*#__PURE__*/_react.default.createElement(_processor_outcome_preview.ProcessorOutcomePreview, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 32
    }
  }), isViewingDetectedFields && /*#__PURE__*/_react.default.createElement(_detected_fields_editor.DetectedFieldsEditor, {
    schemaEditorFields: schemaEditorFields,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 35
    }
  }));
};
exports.SimulationPlayground = SimulationPlayground;
const ProgressBar = () => {
  const isLoading = (0, _stream_enrichment_state_machine.useSimulatorSelector)(state => state.matches('debouncingChanges') || state.matches('runningSimulation'));
  return isLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "xs",
    color: "accent",
    position: "absolute",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 23
    }
  });
};