"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RootStreamEmptyPrompt = exports.NoStepsEmptyPrompt = exports.NoProcessingDataAvailableEmptyPrompt = exports.NoPreviewDocumentsEmptyPrompt = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_streams_app_params = require("../../../hooks/use_streams_app_params");
var _use_streams_app_router = require("../../../hooks/use_streams_app_router");
var _asset_image = require("../../asset_image");
var _create_step_button = require("./create_step_button");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_enrichment/empty_prompts.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const RootStreamEmptyPrompt = () => {
  const router = (0, _use_streams_app_router.useStreamsAppRouter)();
  const {
    path: {
      key: streamName
    }
  } = (0, _use_streams_app_params.useStreamsAppParams)('/{key}/management/{tab}');
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    "aria-live": "polite",
    titleSize: "xs",
    icon: /*#__PURE__*/_react.default.createElement(_asset_image.AssetImage, {
      type: "processorsCannotBeAddedToRootStreams",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 33,
        columnNumber: 13
      }
    }),
    title: /*#__PURE__*/_react.default.createElement("h2", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 35,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.rootStreamEmptyPrompt.title', {
      defaultMessage: 'Processors cannot be added to root streams'
    })),
    body: /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 43,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.rootStreamEmptyPrompt.body', {
      defaultMessage: 'To transform your data with processors, partition a new child stream.'
    })),
    actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      href: router.link('/{key}/management/{tab}', {
        path: {
          key: streamName,
          tab: 'partitioning'
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 54,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.rootStreamEmptyPrompt.button', {
      defaultMessage: 'Open stream partitioning'
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 5
    }
  });
};
exports.RootStreamEmptyPrompt = RootStreamEmptyPrompt;
const NoStepsEmptyPrompt = () => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    "aria-live": "polite",
    titleSize: "xs",
    icon: /*#__PURE__*/_react.default.createElement(_asset_image.AssetImage, {
      type: "extractFields",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 79,
        columnNumber: 13
      }
    }),
    title: /*#__PURE__*/_react.default.createElement("h2", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 81,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.noStepsEmptyPrompt.title', {
      defaultMessage: 'Transform your data before indexing by:'
    })),
    body: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 88,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 89,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 90,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.noStepsEmptyPrompt.body', {
      defaultMessage: 'Create conditions to focus on specific data in your stream.'
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 99,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 100,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.noStepsEmptyPrompt.body', {
      defaultMessage: 'Create processors to extract meaningful fields so you can filter and analyze your data effectively.'
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 110,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 111,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_create_step_button.CreateStepButton, {
      mode: "prominent",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 112,
        columnNumber: 13
      }
    }))),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 5
    }
  });
};
exports.NoStepsEmptyPrompt = NoStepsEmptyPrompt;
const NoPreviewDocumentsEmptyPrompt = () => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    "aria-live": "polite",
    icon: /*#__PURE__*/_react.default.createElement(_asset_image.AssetImage, {
      type: "noResults",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 124,
        columnNumber: 13
      }
    }),
    titleSize: "s",
    title: /*#__PURE__*/_react.default.createElement("h2", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 127,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.outcomePreviewTable.noFilteredDocumentsTitle', {
      defaultMessage: 'No documents available'
    })),
    body: /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 135,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.outcomePreviewTable.noFilteredDocumentsBody', {
      defaultMessage: 'The current filter settings do not match any documents.'
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 5
    }
  });
};
exports.NoPreviewDocumentsEmptyPrompt = NoPreviewDocumentsEmptyPrompt;
const NoProcessingDataAvailableEmptyPrompt = () => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    "aria-live": "polite",
    color: "warning",
    iconType: "warning",
    titleSize: "s",
    title: /*#__PURE__*/_react.default.createElement("h2", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 156,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.outcomePreviewTable.noDataTitle', {
      defaultMessage: 'No data available to validate processor changes'
    })),
    body: /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 164,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.processor.outcomePreviewTable.noDataBody', {
      defaultMessage: 'Changes will be applied, but we can’t confirm they’ll work as expected. Proceed with caution.'
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 5
    }
  });
};
exports.NoProcessingDataAvailableEmptyPrompt = NoProcessingDataAvailableEmptyPrompt;