"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DATA_SOURCES_I18N = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_enrichment/data_sources_flyout/translations.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const DATA_SOURCES_I18N = exports.DATA_SOURCES_I18N = {
  flyout: {
    title: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.dataSourcesFlyout.title', {
      defaultMessage: 'Manage simulation data sources'
    }),
    subtitle: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.dataSourcesFlyout.subtitle', {
      defaultMessage: 'Configure data sources for simulation and testing. Each data source provides sample data for your analysis.'
    }),
    infoDescription: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.dataSourcesFlyout.infoDescription', {
      defaultMessage: 'Select a data source to be used for the processing simulation or create a new one.'
    }),
    infoTitle: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.dataSourcesFlyout.infoTitle', {
      defaultMessage: 'Data sources'
    })
  },
  contextMenu: {
    addDataSource: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.dataSourcesFlyout.addDataSource.menu', {
      defaultMessage: 'Add data source'
    }),
    addKqlDataSource: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.dataSourcesFlyout.addDataSource.menu.addKqlDataSource', {
      defaultMessage: 'Add KQL search samples'
    }),
    addCustomSamples: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.dataSourcesFlyout.addDataSource.menu.addCustomSamples', {
      defaultMessage: 'Add custom docs samples'
    })
  },
  dataSourceCard: {
    enabled: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.dataSourcesFlyout.dataSourceCard.enabled', {
      defaultMessage: 'Enabled'
    }),
    disabled: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.dataSourcesFlyout.dataSourceCard.disabled', {
      defaultMessage: 'Disabled'
    }),
    deleteDataSourceLabel: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.dataSourcesFlyout.dataSourceCard.deleteDataSourceLabel', {
      defaultMessage: 'Delete data source'
    }),
    deleteDataSourceDisabledLabel: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.dataSourcesFlyout.dataSourceCard.deleteDataSourceDisabledLabel', {
      defaultMessage: 'Cannot delete data source while it is selected. Switch to another data source first.'
    }),
    dataPreviewAccordionLabel: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.dataSourcesFlyout.dataSourceCard.dataPreviewAccordion.label', {
      defaultMessage: 'Data preview'
    }),
    noDataPreview: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.dataSourcesFlyout.dataSourceCard.dataPreviewAccordion.noData', {
      defaultMessage: 'No documents to preview available'
    }),
    delete: {
      title: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.dataSourcesFlyout.dataSourceCard.delete.title', {
        defaultMessage: 'Remove sample data source?'
      }),
      message: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.dataSourcesFlyout.dataSourceCard.delete.message', {
        defaultMessage: 'Removed sample data source will need to be reconfigured.'
      }),
      cancelButtonText: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.dataSourcesFlyout.dataSourceCard.delete.cancelButtonText', {
        defaultMessage: 'Cancel'
      }),
      confirmButtonText: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.dataSourcesFlyout.dataSourceCard.delete.confirmButtonText', {
        defaultMessage: 'Delete'
      })
    }
  },
  latestSamples: {
    defaultName: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.dataSources.latestSamples.name', {
      defaultMessage: 'Latest samples'
    }),
    placeholderName: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.dataSources.latestSamples.placeholderName', {
      defaultMessage: 'Latest samples'
    }),
    subtitle: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.dataSources.latestSamples.subtitle', {
      defaultMessage: 'Sample the last 100 documents.'
    }),
    callout: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.dataSources.latestSamples.callout', {
      defaultMessage: 'The latest samples data source cannot be deleted to guarantee available samples for the simulation.'
    })
  },
  kqlDataSource: {
    defaultName: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.dataSourcesFlyout.kqlDataSource.defaultName', {
      defaultMessage: 'KQL search samples'
    }),
    placeholderName: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.dataSourcesFlyout.kqlDataSource.placeholderName', {
      defaultMessage: 'KQL search samples'
    }),
    subtitle: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.dataSourcesFlyout.kqlDataSource.subtitle', {
      defaultMessage: 'Sample data using KQL query syntax.'
    })
  },
  customSamples: {
    defaultName: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.dataSourcesFlyout.customSamples.defaultName', {
      defaultMessage: 'Custom samples'
    }),
    placeholderName: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.dataSourcesFlyout.customSamples.placeholderName', {
      defaultMessage: 'Custom samples'
    }),
    subtitle: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.dataSourcesFlyout.customSamples.subtitle', {
      defaultMessage: 'Manually defined sample documents.'
    }),
    label: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.dataSourcesFlyout.customSamples.label', {
      defaultMessage: 'Documents'
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.streams.streamDetailView.managementTab.enrichment.dataSourcesFlyout.customSamples.helpText",
      defaultMessage: "Use JSON format: {code}",
      values: {
        code: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 157,
            columnNumber: 13
          }
        }, JSON.stringify([{
          '@timestamp': '2025-06-17T12:00:00Z',
          message: 'Sample log message'
        }]))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 152,
        columnNumber: 7
      }
    })
  },
  nameField: {
    label: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.dataSourcesFlyout.nameField.label', {
      defaultMessage: 'Name'
    }),
    helpText: _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.dataSourcesFlyout.nameField.helpText', {
      defaultMessage: 'Describe what samples the data source loads.'
    })
  }
};