"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataSourcesFlyout = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _stream_enrichment_state_machine = require("../state_management/stream_enrichment_state_machine");
var _translations = require("./translations");
var _add_data_sources_context_menu = require("./add_data_sources_context_menu");
var _data_source = require("./data_source");
var _data_source_card = require("./data_source_card");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_enrichment/data_sources_flyout/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const DataSourcesFlyout = ({
  onClose
}) => {
  const dataSourcesActorRefs = (0, _stream_enrichment_state_machine.useStreamEnrichmentSelector)(snapshot => snapshot.context.dataSourcesRefs);
  const flyoutTitleId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutResizable, {
    onClose: onClose,
    size: "m",
    "aria-labelledby": flyoutTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: flyoutTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 11
    }
  }, _translations.DATA_SOURCES_I18N.flyout.title)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    component: "p",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 9
    }
  }, _translations.DATA_SOURCES_I18N.flyout.subtitle)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    banner: /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: _translations.DATA_SOURCES_I18N.flyout.infoDescription,
      iconType: "pin",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 52,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.streams.streamDetailView.managementTab.enrichment.dataSourcesFlyout.partialSimulationDisclaimer",
      tagName: "p",
      defaultMessage: "{partialSimulationBadge} means this data source can only simulate the part of the pipeline that includes the newly added processors, because the original, unprocessed data content is not guaranteed.",
      values: {
        partialSimulationBadge: /*#__PURE__*/_react.default.createElement(_data_source_card.PartialSimulationBadge, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 58,
            columnNumber: 41
          }
        })
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 53,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.streams.streamDetailView.managementTab.enrichment.dataSourcesFlyout.completeSimulationDisclaimer",
      tagName: "p",
      defaultMessage: "{completeSimulationBadge} means this data source can simulate the whole pipeline, since the original data content is guaranteed.",
      values: {
        completeSimulationBadge: /*#__PURE__*/_react.default.createElement(_data_source_card.CompleteSimulationBadge, {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 66,
            columnNumber: 42
          }
        })
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 13
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 13
    }
  }, _translations.DATA_SOURCES_I18N.flyout.infoTitle)), /*#__PURE__*/_react.default.createElement(_add_data_sources_context_menu.AddDataSourcesContextMenu, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    component: "ul",
    direction: "column",
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 9
    }
  }, dataSourcesActorRefs.map(dataSourceRef => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: dataSourceRef.id,
    component: "li",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_data_source.DataSource, {
    dataSourceRef: dataSourceRef,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 15
    }
  }))))));
};
exports.DataSourcesFlyout = DataSourcesFlyout;