"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PartialSimulationBadge = exports.DataSourceCard = exports.CompleteSimulationBadge = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _objectUtils = require("@kbn/object-utils");
var _react2 = require("@emotion/react");
var _use_discard_confirm = require("../../../../hooks/use_discard_confirm");
var _data_source_state_machine = require("../state_management/data_source_state_machine");
var _asset_image = require("../../../asset_image");
var _preview_table = require("../../shared/preview_table");
var _translations = require("./translations");
var _stream_enrichment_state_machine = require("../state_management/stream_enrichment_state_machine");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_enrichment/data_sources_flyout/data_source_card.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const DataSourceCard = ({
  children,
  dataSourceRef,
  title,
  subtitle,
  isPreviewVisible,
  isForCompleteSimulation = false
}) => {
  const {
    selectDataSource
  } = (0, _stream_enrichment_state_machine.useStreamEnrichmentEvents)();
  const dataSourceState = (0, _data_source_state_machine.useDataSourceSelector)(dataSourceRef, snapshot => snapshot);
  const {
    data: previewDocs,
    dataSource
  } = dataSourceState.context;
  const canDeleteDataSource = dataSourceState.can({
    type: 'dataSource.delete'
  });
  const isEnabled = dataSourceState.matches('enabled');
  const isLoading = dataSourceState.matches({
    enabled: 'loadingData'
  });
  const isDeletableDataSource = dataSource.type !== 'latest-samples'; // We don't allow deleting the latest-samples source to always have a data source available

  const handleSelection = () => selectDataSource(dataSourceRef.id);
  const deleteDataSource = (0, _use_discard_confirm.useDiscardConfirm)(() => dataSourceRef.send({
    type: 'dataSource.delete'
  }), {
    title: _translations.DATA_SOURCES_I18N.dataSourceCard.delete.title,
    message: _translations.DATA_SOURCES_I18N.dataSourceCard.delete.message,
    cancelButtonText: _translations.DATA_SOURCES_I18N.dataSourceCard.delete.cancelButtonText,
    confirmButtonText: _translations.DATA_SOURCES_I18N.dataSourceCard.delete.confirmButtonText
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCheckableCard, {
    id: `dataSourceCard-${dataSource.type}-${dataSourceRef.id}`,
    css: (0, _react2.css)`
        [class*='euiSplitPanel__inner']:has(> label.euiCheckableCard__label) {
          overflow-block: auto;
        }
      `,
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 84,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween",
      alignItems: "center",
      gutterSize: "m",
      wrap: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 85,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 86,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("h3", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 87,
        columnNumber: 15
      }
    }, title !== null && title !== void 0 ? title : dataSource.type)), isForCompleteSimulation ? /*#__PURE__*/_react.default.createElement(CompleteSimulationBadge, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 89,
        columnNumber: 40
      }
    }) : /*#__PURE__*/_react.default.createElement(PartialSimulationBadge, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 89,
        columnNumber: 70
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 90,
        columnNumber: 13
      }
    }), isDeletableDataSource && /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: !canDeleteDataSource ? _translations.DATA_SOURCES_I18N.dataSourceCard.deleteDataSourceDisabledLabel : undefined,
      disableScreenReaderOutput: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 92,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: "trash",
      disabled: !canDeleteDataSource,
      onClick: deleteDataSource,
      "aria-label": _translations.DATA_SOURCES_I18N.dataSourceCard.deleteDataSourceLabel,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 100,
        columnNumber: 17
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      component: "p",
      color: "subdued",
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 109,
        columnNumber: 11
      }
    }, subtitle)),
    onChange: handleSelection,
    checked: isEnabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 5
    }
  }, children, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: dataSourceRef.id,
    buttonContent: _translations.DATA_SOURCES_I18N.dataSourceCard.dataPreviewAccordionLabel,
    initialIsOpen: isPreviewVisible,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 9
    }
  }), isLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "xs",
    color: "accent",
    position: "absolute",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 23
    }
  }), (0, _lodash.isEmpty)(previewDocs) ? /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    icon: /*#__PURE__*/_react.default.createElement(_asset_image.AssetImage, {
      type: "noResults",
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 127,
        columnNumber: 19
      }
    }),
    titleSize: "xs",
    title: /*#__PURE__*/_react.default.createElement("h4", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 129,
        columnNumber: 20
      }
    }, _translations.DATA_SOURCES_I18N.dataSourceCard.noDataPreview),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 11
    }
  }) : /*#__PURE__*/_react.default.createElement(_preview_table.PreviewTable, {
    documents: previewDocs.map(_objectUtils.flattenObjectNestedLast),
    height: 150,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 11
    }
  })));
};
exports.DataSourceCard = DataSourceCard;
const PartialSimulationBadge = ({
  short = false
}) => {
  const label = short ? _i18n.i18n.translate('xpack.streams.dataSourceCard.partialSimulationBadgeShortLabel', {
    defaultMessage: 'Partial'
  }) : _i18n.i18n.translate('xpack.streams.dataSourceCard.partialSimulationBadgeLabel', {
    defaultMessage: 'Partial simulation'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: short ? _i18n.i18n.translate('xpack.streams.dataSourceCard.partialSimulationBadgeLabel', {
      defaultMessage: 'This data source can only simulate the part of the pipeline that includes the newly added processors, because the original, unprocessed data content is not guaranteed.'
    }) : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    tabIndex: 0,
    color: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 7
    }
  }, label));
};
exports.PartialSimulationBadge = PartialSimulationBadge;
const CompleteSimulationBadge = ({
  short = false
}) => {
  const label = short ? _i18n.i18n.translate('xpack.streams.dataSourceCard.completeSimulationBadgeShortLabel', {
    defaultMessage: 'Complete'
  }) : _i18n.i18n.translate('xpack.streams.dataSourceCard.completeSimulationBadgeLabel', {
    defaultMessage: 'Complete simulation'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: short ? _i18n.i18n.translate('xpack.streams.dataSourceCard.completeSimulationBadgeLabel', {
      defaultMessage: 'This data source can simulate the whole pipeline, since the original data content is guaranteed.'
    }) : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    tabIndex: 0,
    color: "primary",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 7
    }
  }, label));
};
exports.CompleteSimulationBadge = CompleteSimulationBadge;