"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomSamplesDataSourceCard = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _codeEditor = require("@kbn/code-editor");
var _streamsSchema = require("@kbn/streams-schema");
var _reactHooks = require("@kbn/react-hooks");
var _url_schema = require("../../../../../common/url_schema");
var _data_source_state_machine = require("../state_management/data_source_state_machine");
var _helpers = require("../helpers");
var _data_source_card = require("./data_source_card");
var _name_field = require("./name_field");
var _translations = require("./translations");
var _utils = require("../utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_enrichment/data_sources_flyout/custom_samples_data_source_card.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const debounceOptions = {
  wait: 500
};
const CustomSamplesDataSourceCard = ({
  dataSourceRef
}) => {
  const dataSource = (0, _data_source_state_machine.useDataSourceSelector)(dataSourceRef, snapshot => snapshot.context.dataSource);
  const isDisabled = (0, _data_source_state_machine.useDataSourceSelector)(dataSourceRef, snapshot => !snapshot.can({
    type: 'dataSource.change',
    dataSource
  }));
  const {
    run: handleStorageUpdate
  } = (0, _reactHooks.useDebounceFn)(newDataSource => {
    if (newDataSource.storageKey) {
      const urlSchemaDataSource = _utils.dataSourceConverter.toUrlSchema(newDataSource);
      sessionStorage.setItem(newDataSource.storageKey, JSON.stringify(urlSchemaDataSource));
    }
  }, debounceOptions);
  const handleChange = updates => {
    const newDataSource = {
      ...dataSource,
      ...updates
    };
    dataSourceRef.send({
      type: 'dataSource.change',
      dataSource: newDataSource
    });
    handleStorageUpdate(newDataSource);
  };

  /**
   * To have the editor properly handle the set xjson language
   * we need to avoid the continuous parsing/serialization of the editor value
   * using a parallel state always setting a string make the editor format well the content.
   */
  const [editorValue, setEditorValue] = _react.default.useState(() => (0, _helpers.serializeXJson)(dataSource.documents, '[]'));
  const handleEditorChange = value => {
    setEditorValue(value);
    const documents = (0, _helpers.deserializeJson)(value);
    if ((0, _streamsSchema.isSchema)(_url_schema.customSamplesDataSourceDocumentsSchema, documents)) {
      handleChange({
        documents
      });
    }
  };
  return /*#__PURE__*/_react.default.createElement(_data_source_card.DataSourceCard, {
    dataSourceRef: dataSourceRef,
    title: _translations.DATA_SOURCES_I18N.customSamples.defaultName,
    subtitle: _translations.DATA_SOURCES_I18N.customSamples.subtitle,
    isForCompleteSimulation: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_name_field.NameField, {
    onChange: event => handleChange({
      name: event.target.value
    }),
    value: dataSource.name,
    disabled: isDisabled,
    "data-test-subj": "streamsAppCustomSamplesDataSourceNameField",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _translations.DATA_SOURCES_I18N.customSamples.label,
    helpText: _translations.DATA_SOURCES_I18N.customSamples.helpText,
    isDisabled: isDisabled,
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_codeEditor.CodeEditor, {
    dataTestSubj: "streamsAppCustomSamplesDataSourceEditor",
    height: 200,
    value: editorValue,
    onChange: handleEditorChange,
    languageId: "xjson",
    options: {
      tabSize: 2,
      readOnly: isDisabled,
      automaticLayout: true
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 7
    }
  }));
};
exports.CustomSamplesDataSourceCard = CustomSamplesDataSourceCard;