"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataSourcesControls = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _sharedUxUtility = require("@kbn/shared-ux-utility");
var _react2 = require("@emotion/react");
var _stream_enrichment_state_machine = require("./state_management/stream_enrichment_state_machine");
var _utils = require("./state_management/stream_enrichment_state_machine/utils");
var _translations = require("./data_sources_flyout/translations");
var _data_source_card = require("./data_sources_flyout/data_source_card");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_enrichment/data_sources_controls.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DataSourcesFlyout = (0, _sharedUxUtility.dynamic)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./data_sources_flyout'))).then(mod => ({
  default: mod.DataSourcesFlyout
})));
const manageDataSourcesLabel = _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.openDataSourcesManagement.label', {
  defaultMessage: 'Manage data sources'
});
const DataSourcesControls = () => {
  const {
    closeDataSourcesManagement,
    openDataSourcesManagement
  } = (0, _stream_enrichment_state_machine.useStreamEnrichmentEvents)();
  const isManagingDataSources = (0, _stream_enrichment_state_machine.useStreamEnrichmentSelector)(state => state.matches({
    ready: {
      enrichment: {
        managingDataSources: 'open'
      }
    }
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    wrap: false,
    alignItems: "center",
    gutterSize: "s",
    "data-test-subj": "streamsAppProcessingDataSourcesList",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(DataSourceSelector, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "xs",
    hasShadow: false,
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: manageDataSourcesLabel,
    disableScreenReaderOutput: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "streamsAppProcessingManageDataSourcesButton",
    iconType: "controls",
    onClick: openDataSourcesManagement,
    "aria-label": manageDataSourcesLabel,
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 11
    }
  }))), isManagingDataSources && /*#__PURE__*/_react.default.createElement(DataSourcesFlyout, {
    onClose: closeDataSourcesManagement,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 33
    }
  }));
};
exports.DataSourcesControls = DataSourcesControls;
const DataSourceSelector = () => {
  const {
    selectDataSource
  } = (0, _stream_enrichment_state_machine.useStreamEnrichmentEvents)();
  const dataSourcesRefs = (0, _stream_enrichment_state_machine.useStreamEnrichmentSelector)(state => state.context.dataSourcesRefs);
  const selectedDataSourceRef = (0, _stream_enrichment_state_machine.useStreamEnrichmentSelector)(state => (0, _utils.getActiveDataSourceRef)(state.context.dataSourcesRefs));
  const options = dataSourcesRefs.map(dataSourceRef => {
    const snapshot = dataSourceRef.getSnapshot();
    const name = snapshot.context.dataSource.name || snapshot.context.dataSource.type;
    return {
      value: dataSourceRef.id,
      inputDisplay: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "center",
        justifyContent: "spaceBetween",
        gutterSize: "xs",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 86,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement("span", {
        className: "eui-textTruncate",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 87,
          columnNumber: 11
        }
      }, name), snapshot.context.simulationMode === 'partial' ? /*#__PURE__*/_react.default.createElement(_data_source_card.PartialSimulationBadge, {
        short: true,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 89,
          columnNumber: 13
        }
      }) : /*#__PURE__*/_react.default.createElement(_data_source_card.CompleteSimulationBadge, {
        short: true,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 91,
          columnNumber: 13
        }
      })),
      dropdownDisplay: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        direction: "column",
        gutterSize: "xs",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 96,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "center",
        justifyContent: "spaceBetween",
        gutterSize: "xs",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 97,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement("strong", {
        className: "eui-textTruncate",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 98,
          columnNumber: 13
        }
      }, name), snapshot.context.simulationMode === 'partial' ? /*#__PURE__*/_react.default.createElement(_data_source_card.PartialSimulationBadge, {
        short: true,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 100,
          columnNumber: 15
        }
      }) : /*#__PURE__*/_react.default.createElement(_data_source_card.CompleteSimulationBadge, {
        short: true,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 102,
          columnNumber: 15
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        component: "p",
        size: "xs",
        color: "subdued",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 105,
          columnNumber: 11
        }
      }, getOptionSubtitle(snapshot.context.dataSource.type)))
    };
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    "aria-label": _i18n.i18n.translate('xpack.streams.dataSource.dataSourceSelector.ariaLabel', {
      defaultMessage: 'Select a data source...'
    }),
    "data-test-subj": "streamsAppProcessingDataSourceSelector",
    options: options,
    valueOfSelected: selectedDataSourceRef === null || selectedDataSourceRef === void 0 ? void 0 : selectedDataSourceRef.id,
    onChange: id => selectDataSource(id),
    hasDividers: true,
    css: (0, _react2.css)`
        width: 280px;
      `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 5
    }
  });
};
const getOptionSubtitle = dataSourceType => {
  switch (dataSourceType) {
    case 'latest-samples':
      return _translations.DATA_SOURCES_I18N.latestSamples.subtitle;
    case 'kql-samples':
      return _translations.DATA_SOURCES_I18N.kqlDataSource.subtitle;
    case 'custom-samples':
      return _translations.DATA_SOURCES_I18N.customSamples.subtitle;
  }
};