"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateStepButton = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _useToggle = _interopRequireDefault(require("react-use/lib/useToggle"));
var _i18n = require("@kbn/i18n");
var _stream_enrichment_state_machine = require("./state_management/stream_enrichment_state_machine");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/stream_detail_enrichment/create_step_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const createConditionText = _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.createConditionButtonText', {
  defaultMessage: 'Create condition'
});
const createProcessorText = _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.createProcessorButtonText', {
  defaultMessage: 'Create processor'
});
const createTextProminent = _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.createButtonTextProminent', {
  defaultMessage: 'Create your first step'
});
const createText = _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.addButtonText', {
  defaultMessage: 'Create'
});
const CreateStepButton = ({
  parentId,
  mode,
  nestingDisabled = false
}) => {
  const {
    addProcessor,
    addCondition
  } = (0, _stream_enrichment_state_machine.useStreamEnrichmentEvents)();
  const canAddStep = (0, _stream_enrichment_state_machine.useStreamEnrichmentSelector)(state => state.can({
    type: 'step.addProcessor'
  }) || state.can({
    type: 'step.addCondition'
  }));
  const [isPopoverOpen, togglePopover] = (0, _useToggle.default)(false);
  const menuPopoverId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'addStepContextMenuPopover'
  });
  const items = [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    "data-test-subj": "streamsAppStreamDetailEnrichmentCreateStepButtonAddCondition",
    key: "addCondition",
    icon: "timeline",
    disabled: nestingDisabled,
    onClick: () => {
      togglePopover(false);
      addCondition(undefined, {
        parentId: parentId !== null && parentId !== void 0 ? parentId : null
      });
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 5
    }
  }, createConditionText), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    "data-test-subj": "streamsAppStreamDetailEnrichmentCreateStepButtonAddProcessor",
    key: "addProcessor",
    icon: "compute",
    onClick: () => {
      togglePopover(false);
      addProcessor(undefined, {
        parentId: parentId !== null && parentId !== void 0 ? parentId : null
      });
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 5
    }
  }, createProcessorText)];
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    size: "s",
    onClick: togglePopover,
    disabled: !canAddStep,
    "data-test-subj": "streamsAppStreamDetailEnrichmentCreateStepButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 5
    }
  }, mode === 'prominent' ? createTextProminent : createText, mode === 'prominent' || mode === 'subdued' ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "arrowDown",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 53
    }
  }) : null);
  const inlineButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "streamsAppStreamDetailEnrichmentCreateStepButtonInline",
    size: "xs",
    iconType: "plusInCircle",
    onClick: togglePopover,
    disabled: !canAddStep,
    "aria-label": _i18n.i18n.translate('xpack.streams.streamDetailView.managementTab.enrichment.createStepButtonInlineAriaLabel', {
      defaultMessage: 'Create nested step'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 5
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: menuPopoverId,
    button: mode === 'inline' ? inlineButton : button,
    isOpen: isPopoverOpen,
    closePopover: () => togglePopover(false),
    panelPaddingSize: "none",
    anchorPosition: "downLeft",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    size: "s",
    items: items,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 7
    }
  }));
};
exports.CreateStepButton = CreateStepButton;