"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PreviewTableCell = PreviewTableCell;
exports.isDocumentWithIgnoredFields = isDocumentWithIgnoredFields;
var _eui = require("@elastic/eui");
var _discoverContextualComponents = require("@kbn/discover-contextual-components");
var _unifiedDataTable = require("@kbn/unified-data-table");
var _react = _interopRequireWildcard(require("react"));
var _preview_table = require("./preview_table");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/shared/preview_table_cell.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const emptyCell = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, "\xA0");
const EMPTY_IGNORED_FIELDS = [];
function isDocumentWithIgnoredFields(doc) {
  return 'ignored_fields' in doc && Array.isArray(doc.ignored_fields);
}
const PreviewTableCellContent = /*#__PURE__*/(0, _react.memo)(function PreviewTableCellContent({
  rowIndex,
  columnId,
  setCellProps,
  isDetails,
  isExpanded,
  isExpandable,
  colIndex,
  document,
  ignoredFields,
  mode,
  dataView,
  currentRowHeights,
  renderCellValue,
  core,
  share,
  fieldFormats
}) {
  // Special rendering for summary column
  if (columnId === _preview_table.SUMMARY_COLUMN_ID && mode === 'summary' && dataView) {
    // Convert to DataTableRecord format expected by SummaryColumn
    // No normalization - pass documents as-is with OTel fields
    // The kbn-discover-utils will handle OTel field fallbacks
    const dataTableRecord = {
      raw: document,
      flattened: document,
      id: `${rowIndex}-summary`
    };
    let rowHeight;
    if (currentRowHeights) {
      const {
        defaultHeight
      } = currentRowHeights;
      if (defaultHeight === 'auto') {
        rowHeight = _unifiedDataTable.ROWS_HEIGHT_OPTIONS.auto;
      } else if (defaultHeight && typeof defaultHeight === 'object' && 'lineCount' in defaultHeight && defaultHeight.lineCount) {
        rowHeight = defaultHeight.lineCount;
      }
    }
    return /*#__PURE__*/_react.default.createElement(_discoverContextualComponents.LazySummaryColumn, {
      dataView: dataView,
      row: dataTableRecord,
      rowIndex: rowIndex,
      columnId: columnId,
      isDetails: isDetails,
      setCellProps: setCellProps,
      isExpandable: isExpandable,
      isExpanded: isExpanded,
      colIndex: colIndex,
      closePopover: () => {},
      density: _unifiedDataTable.DataGridDensity.COMPACT,
      rowHeight: rowHeight,
      shouldShowFieldHandler: () => true,
      core: core,
      share: share,
      fieldFormats: fieldFormats,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 104,
        columnNumber: 7
      }
    });
  }
  if (renderCellValue) {
    const renderedValue = renderCellValue(document, columnId, ignoredFields);
    if (renderedValue !== undefined) {
      return renderedValue;
    }
  }
  const value = document[columnId];
  if (value === undefined || value === null) {
    return emptyCell;
  }
  if (typeof value === 'object') {
    return JSON.stringify(value);
  }
  return String(value) || emptyCell;
});
function PreviewTableCell({
  rowIndex,
  columnId,
  setCellProps,
  isDetails,
  isExpanded,
  isExpandable,
  colIndex,
  documents,
  mode,
  dataView,
  currentRowHeights,
  renderCellValue,
  core,
  share,
  fieldFormats
}) {
  const {
    euiTheme: theme
  } = (0, _eui.useEuiTheme)();
  const {
    selectedRowIndex
  } = (0, _react.useContext)(_preview_table.RowSelectionContext);
  if (selectedRowIndex === rowIndex) {
    setCellProps({
      style: {
        backgroundColor: theme.colors.highlight
      }
    });
  } else {
    setCellProps({
      style: {}
    });
  }
  const doc = documents[rowIndex];
  const document = isDocumentWithIgnoredFields(doc) ? doc.values : doc;
  const ignoredFields = isDocumentWithIgnoredFields(doc) ? doc.ignored_fields : EMPTY_IGNORED_FIELDS;
  if (!document || typeof document !== 'object') {
    return emptyCell;
  }

  // Memoized content rendering
  return /*#__PURE__*/_react.default.createElement(PreviewTableCellContent, {
    rowIndex: rowIndex,
    columnId: columnId,
    setCellProps: setCellProps,
    isDetails: isDetails,
    isExpanded: isExpanded,
    isExpandable: isExpandable,
    colIndex: colIndex,
    document: document,
    ignoredFields: ignoredFields,
    mode: mode,
    dataView: dataView,
    currentRowHeights: currentRowHeights,
    renderCellValue: renderCellValue,
    core: core,
    share: share,
    fieldFormats: fieldFormats,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 5
    }
  });
}