"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MemoPreviewTable = void 0;
exports.PreviewTable = PreviewTable;
exports.SUMMARY_COLUMN_ID = exports.RowSelectionContext = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _column_header_truncate_container = _interopRequireDefault(require("@kbn/unified-data-table/src/components/column_header_truncate_container"));
var _reactField = require("@kbn/react-field");
var _react2 = _interopRequireWildcard(require("react"));
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
var _utils = require("../stream_detail_enrichment/utils");
var _use_kibana = require("../../../hooks/use_kibana");
var _preview_table_cell = require("./preview_table_cell");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/shared/preview_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SUMMARY_COLUMN_ID = exports.SUMMARY_COLUMN_ID = _i18n.i18n.translate('xpack.streams.resultPanel.euiDataGrid.summaryColumnId', {
  defaultMessage: '(Summary)'
});
const SUMMARY_COLUMN_WIDTH_WITH_SIBLINGS = 600;
const RowSelectionContext = exports.RowSelectionContext = /*#__PURE__*/(0, _react2.createContext)({});
const useRowSelection = () => (0, _react2.useContext)(RowSelectionContext);
function RowSelectionButton({
  rowIndex
}) {
  const {
    selectedRowIndex,
    onRowSelected
  } = useRowSelection();
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonIcon, {
    onClick: () => {
      if (onRowSelected) {
        onRowSelected(rowIndex);
      }
    },
    "aria-label": _i18n.i18n.translate('xpack.streams.resultPanel.euiDataGrid.preview.selectRowAriaLabel', {
      defaultMessage: 'Select row {rowIndex}',
      values: {
        rowIndex: rowIndex + 1
      }
    }),
    iconType: selectedRowIndex === rowIndex ? 'minimize' : 'expand',
    color: selectedRowIndex === rowIndex ? 'primary' : 'text',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 5
    }
  });
}
const MemoPreviewTable = exports.MemoPreviewTable = /*#__PURE__*/_react2.default.memo(PreviewTable);
function PreviewTable({
  documents,
  displayColumns,
  height,
  renderCellValue,
  rowHeightsOptions,
  sorting,
  setSorting,
  toolbarVisibility = false,
  setVisibleColumns,
  columnOrderHint = [],
  showLeadingControlColumns = true,
  cellActions,
  mode = 'columns',
  streamName,
  viewModeToggle,
  dataViewFieldTypes
}) {
  const {
    core,
    dependencies: {
      start: {
        share,
        fieldFormats,
        data
      }
    }
  } = (0, _use_kibana.useKibana)();

  // Create dataView for summary mode
  const {
    value: dataView
  } = (0, _useAsync.default)(async () => {
    if (!streamName) return undefined;
    return data.dataViews.create({
      title: streamName
    });
  }, [streamName, data.dataViews]);
  const {
    euiTheme: theme
  } = (0, _eui.useEuiTheme)();

  // Create a map of field names to their ES types for quick lookup from DataView
  const fieldTypeMap = (0, _react2.useMemo)(() => {
    const typeMap = new Map();
    if (dataViewFieldTypes && dataViewFieldTypes.length > 0) {
      dataViewFieldTypes.forEach(field => {
        // Use esType if available (more specific), otherwise use type
        const fieldType = field.esType || field.type;
        if (fieldType) {
          typeMap.set(field.name, fieldType);
        }
      });
    }
    return typeMap;
  }, [dataViewFieldTypes]);

  // Determine canonical column order
  const canonicalColumnOrder = (0, _react2.useMemo)(() => {
    // In columns mode, show regular columns only
    // In summary mode, show summary column + regular columns
    const cols = new Set();
    documents.forEach(doc => {
      const document = (0, _preview_table_cell.isDocumentWithIgnoredFields)(doc) ? doc.values : doc;
      if (!document || typeof document !== 'object') {
        return;
      }
      Object.keys(document).forEach(key => {
        cols.add(key);
      });
    });
    let allColumns = Array.from(cols);

    // Sort columns by displayColumns or alphabetically as baseline
    allColumns = allColumns.sort((a, b) => {
      const indexA = (displayColumns || []).indexOf(a);
      const indexB = (displayColumns || []).indexOf(b);
      if (indexA === -1 && indexB === -1) {
        return a.localeCompare(b);
      }
      if (indexA === -1) return 1;
      if (indexB === -1) return -1;
      return indexA - indexB;
    });

    // Sort columns based on the columnOrderHint if provided
    if (columnOrderHint.length > 0) {
      const orderedCols = columnOrderHint.filter(col => allColumns.includes(col));
      const unorderedCols = allColumns.filter(col => !orderedCols.includes(col));
      allColumns = [...orderedCols, ...unorderedCols];
    }
    // Always show the displayColumns first, but preserve the order from allColumns
    if (displayColumns) {
      const displaySet = new Set(displayColumns);
      allColumns = [...allColumns.filter(col => displaySet.has(col)), ...allColumns.filter(col => !displaySet.has(col))];
    }
    if (mode === 'summary') {
      return [SUMMARY_COLUMN_ID, ...allColumns];
    }
    return allColumns;
  }, [columnOrderHint, displayColumns, documents, mode]);

  // Derive visibleColumns from canonical order
  const visibleColumns = (0, _react2.useMemo)(() => {
    // In summary mode, only show summary column + explicitly enabled columns
    if (mode === 'summary') {
      if (!displayColumns || displayColumns.length === 0) {
        // If no columns specified, show only summary column
        return [SUMMARY_COLUMN_ID];
      }
      const filteredColumns = canonicalColumnOrder.filter(col => col !== SUMMARY_COLUMN_ID && displayColumns.includes(col));
      return [SUMMARY_COLUMN_ID, ...filteredColumns];
    }

    // In columns mode, show all or filtered columns (no summary)
    const filteredColumns = displayColumns ? canonicalColumnOrder.filter(col => col !== SUMMARY_COLUMN_ID && displayColumns.includes(col)) : canonicalColumnOrder.filter(col => col !== SUMMARY_COLUMN_ID);
    return filteredColumns;
  }, [canonicalColumnOrder, displayColumns, mode]);
  const summaryHasSiblings = (0, _react2.useMemo)(() => visibleColumns.some(column => column !== SUMMARY_COLUMN_ID), [visibleColumns]);
  const internalSetVisibleColumns = (0, _react2.useMemo)(() => {
    if (!setVisibleColumns) {
      return undefined;
    }
    if (mode === 'summary') {
      return columns => setVisibleColumns(columns.filter(column => column !== SUMMARY_COLUMN_ID));
    }
    return setVisibleColumns;
  }, [mode, setVisibleColumns]);
  const sortingConfig = (0, _react2.useMemo)(() => {
    if (!sorting && !setSorting) {
      return undefined;
    }
    return {
      columns: sorting !== null && sorting !== void 0 && sorting.fieldName ? [{
        id: (sorting === null || sorting === void 0 ? void 0 : sorting.fieldName) || '',
        direction: (sorting === null || sorting === void 0 ? void 0 : sorting.direction) || 'asc'
      }] : [],
      onSort: newSorting => {
        if (setSorting) {
          const mostRecentSorting = newSorting[newSorting.length - 1];
          setSorting({
            fieldName: mostRecentSorting === null || mostRecentSorting === void 0 ? void 0 : mostRecentSorting.id,
            direction: (mostRecentSorting === null || mostRecentSorting === void 0 ? void 0 : mostRecentSorting.direction) || 'asc'
          });
        }
      }
    };
  }, [setSorting, sorting]);
  const [columnWidths, setColumnWidths] = (0, _react2.useState)({});
  const leadingControlColumns = (0, _react2.useMemo)(() => [{
    id: 'selection',
    width: 36,
    headerCellRender: () => null,
    rowCellRender: ({
      rowIndex,
      setCellProps
    }) => {
      // eslint-disable-next-line react-hooks/rules-of-hooks
      const {
        selectedRowIndex
      } = useRowSelection();
      if (selectedRowIndex === rowIndex) {
        setCellProps({
          style: {
            backgroundColor: theme.colors.highlight
          }
        });
      } else {
        setCellProps({
          style: {}
        });
      }
      return /*#__PURE__*/_react2.default.createElement(RowSelectionButton, {
        rowIndex: rowIndex,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 298,
          columnNumber: 18
        }
      });
    }
  }], [theme.colors.highlight]);
  const onColumnResize = (0, _react2.useCallback)(({
    columnId,
    width
  }) => {
    setColumnWidths(prev => {
      const updated = (0, _utils.recalcColumnWidths)({
        columnId,
        width,
        prevWidths: prev,
        visibleColumns
      });
      return updated;
    });
  }, [visibleColumns]);
  const gridColumns = (0, _react2.useMemo)(() => {
    return canonicalColumnOrder.map(column => {
      // Special handling for summary column
      if (column === SUMMARY_COLUMN_ID) {
        var _columnWidths$column;
        return {
          id: column,
          display: /*#__PURE__*/_react2.default.createElement(_column_header_truncate_container.default, {
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 327,
              columnNumber: 13
            }
          }, _i18n.i18n.translate('xpack.streams.resultPanel.euiDataGrid.summaryColumnLabel', {
            defaultMessage: 'Summary'
          })),
          actions: false,
          isResizable: true,
          initialWidth: (_columnWidths$column = columnWidths[column]) !== null && _columnWidths$column !== void 0 ? _columnWidths$column : summaryHasSiblings ? SUMMARY_COLUMN_WIDTH_WITH_SIBLINGS : undefined
        };
      }
      const columnparts = column.split('.');
      // interlave the columnparts with a dot and a breakable non-whitespace character
      const interleavedColumnParts = columnparts.reduce((acc, part, index) => {
        if (index === 0) {
          return [part];
        }
        return [...acc, '.', /*#__PURE__*/_react2.default.createElement("wbr", {
          key: index,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 347,
            columnNumber: 30
          }
        }), part];
      }, []);

      // Get the field type from the map
      const fieldType = fieldTypeMap.get(column);
      return {
        id: column,
        display: /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
          gutterSize: "s",
          alignItems: "center",
          responsive: false,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 356,
            columnNumber: 11
          }
        }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 357,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react2.default.createElement(_reactField.FieldIcon, {
          type: fieldType || 'unknown',
          size: "s",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 358,
            columnNumber: 15
          }
        })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 360,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react2.default.createElement(_column_header_truncate_container.default, {
          wordBreak: "normal",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 361,
            columnNumber: 15
          }
        }, interleavedColumnParts))),
        actions: Boolean(setVisibleColumns) || Boolean(setSorting) ? {
          showHide: Boolean(setVisibleColumns),
          showMoveLeft: Boolean(setVisibleColumns),
          showMoveRight: Boolean(setVisibleColumns),
          showSortAsc: Boolean(setSorting),
          showSortDesc: Boolean(setSorting)
        } : false,
        initialWidth: columnWidths[column],
        cellActions
      };
    });
  }, [cellActions, canonicalColumnOrder, fieldTypeMap, setSorting, setVisibleColumns, columnWidths, summaryHasSiblings]);
  const [currentRowHeights, setCurrentRowHeights] = (0, _react2.useState)(rowHeightsOptions);
  const renderCustomToolbar = (0, _react2.useCallback)(props => {
    const {
      hasRoomForGridControls,
      columnControl,
      columnSortingControl,
      displayControl,
      fullScreenControl,
      keyboardShortcutsControl
    } = props;
    const mobileStyles = !hasRoomForGridControls && (0, _react.css)`
          .euiDataGridToolbarControl__text {
            ${(0, _eui.euiScreenReaderOnly)()}
          }
        `;
    const viewModeOptions = [{
      id: 'columns',
      label: _i18n.i18n.translate('xpack.streams.processorOutcomePreview.viewMode.columns', {
        defaultMessage: 'Columns'
      })
    }, {
      id: 'summary',
      label: _i18n.i18n.translate('xpack.streams.processorOutcomePreview.viewMode.summary', {
        defaultMessage: 'Summary'
      })
    }];
    return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
      responsive: false,
      gutterSize: "s",
      justifyContent: "spaceBetween",
      alignItems: "center",
      css: mobileStyles,
      className: "euiDataGrid__controls",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 430,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 438,
        columnNumber: 11
      }
    }, viewModeToggle && /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonGroup, {
      legend: _i18n.i18n.translate('xpack.streams.processorOutcomePreview.viewModeToggle.legend', {
        defaultMessage: 'Preview view mode'
      }),
      options: viewModeOptions,
      idSelected: viewModeToggle.currentMode,
      onChange: id => viewModeToggle.setViewMode(id),
      buttonSize: "compressed",
      isDisabled: viewModeToggle.isDisabled,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 440,
        columnNumber: 15
      }
    })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 456,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
      responsive: false,
      gutterSize: "s",
      alignItems: "center",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 457,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 458,
        columnNumber: 15
      }
    }, columnControl), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 459,
        columnNumber: 15
      }
    }, columnSortingControl), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 460,
        columnNumber: 15
      }
    }, keyboardShortcutsControl), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 461,
        columnNumber: 15
      }
    }, displayControl), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 462,
        columnNumber: 15
      }
    }, fullScreenControl))));
  }, [viewModeToggle]);
  const toolbarVisibilityConfig = (0, _react2.useMemo)(() => {
    if (!toolbarVisibility) {
      return false;
    }
    return true;
  }, [toolbarVisibility]);
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiDataGrid, {
    "aria-label": _i18n.i18n.translate('xpack.streams.resultPanel.euiDataGrid.previewLabel', {
      defaultMessage: 'Preview'
    }),
    leadingControlColumns: showLeadingControlColumns && visibleColumns.length > 0 ? leadingControlColumns : undefined,
    columns: gridColumns,
    columnVisibility: {
      visibleColumns,
      setVisibleColumns: internalSetVisibleColumns || (() => {}),
      canDragAndDropColumns: false
    },
    sorting: sortingConfig,
    inMemory: sortingConfig ? {
      level: 'sorting'
    } : undefined,
    height: height,
    toolbarVisibility: toolbarVisibilityConfig,
    renderCustomToolbar: viewModeToggle ? renderCustomToolbar : undefined,
    rowCount: documents.length,
    rowHeightsOptions: {
      ...currentRowHeights,
      onChange: newRowHeightOptions => {
        setCurrentRowHeights(newRowHeightOptions);
      }
    },
    onColumnResize: onColumnResize,
    renderCellValue: props => /*#__PURE__*/_react2.default.createElement(_preview_table_cell.PreviewTableCell, (0, _extends2.default)({}, props, {
      documents: documents,
      mode: mode,
      dataView: dataView,
      currentRowHeights: currentRowHeights,
      renderCellValue: renderCellValue,
      core: core,
      share: share,
      fieldFormats: fieldFormats,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 507,
        columnNumber: 9
      }
    })),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 480,
      columnNumber: 5
    }
  });
}