"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertToFieldDefinitionConfig = void 0;
exports.isFieldUncommitted = isFieldUncommitted;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const convertToFieldDefinitionConfig = field => ({
  type: field.type,
  ...(field.format && field.type === 'date' ? {
    format: field.format
  } : {}),
  ...(field.additionalParameters && Object.keys(field.additionalParameters).length > 0 ? field.additionalParameters : {})
});
exports.convertToFieldDefinitionConfig = convertToFieldDefinitionConfig;
function isFieldUncommitted(field, storedFields) {
  const fieldDefaults = {
    format: undefined,
    additionalParameters: {}
  };
  // Check if field is new (not in stored fields)
  const storedField = storedFields.find(stored => stored.name === field.name);
  if (!storedField) {
    // If the field is not stored yet and is still unmapped, then we didn't touch
    // it and it is not uncommitted, since it won't be saved to the stream definition.
    return field.status !== 'unmapped';
  }

  // Create copies without SchemaEditorField-specific properties (result, uncommitted)
  // to compare only the base SchemaField properties
  const {
    result: _fieldResult,
    uncommitted: _fieldUncommitted,
    ...fieldToCompare
  } = field;
  const {
    result: _storedResult,
    uncommitted: _storedUncommitted,
    ...storedToCompare
  } = storedField;

  // Check if field has been modified (different from stored)
  return !(0, _lodash.isEqual)({
    ...fieldDefaults,
    ...storedToCompare
  }, {
    ...fieldDefaults,
    ...fieldToCompare
  });
}