"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldsTable = FieldsTable;
exports.isSelectableField = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _get_stream_type_from_definition = require("../../../util/get_stream_type_from_definition");
var _constants = require("./constants");
var _field_actions = require("./field_actions");
var _field_parent = require("./field_parent");
var _field_status = require("./field_status");
var _field_result = require("./field_result");
var _field_type = require("./field_type");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/streams_app/public/components/data_management/schema_editor/schema_editor_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function FieldsTable({
  isLoading,
  controls,
  defaultColumns,
  fields,
  stream,
  withTableActions,
  withToolbar,
  selectedFields,
  onFieldSelection
}) {
  // Column visibility
  const [visibleColumns, setVisibleColumns] = (0, _react.useState)(defaultColumns);
  // Column sorting
  const [sortingColumns, setSortingColumns] = (0, _react.useState)([]);
  const filteredFields = (0, _react.useMemo)(() => filterFieldsByControls(fields, controls), [fields, controls]);
  const leadingColumns = (0, _react.useMemo)(() => {
    if (!withTableActions) return undefined;
    return [createFieldSelectionCellRenderer(filteredFields, selectedFields, onFieldSelection, stream.name)];
  }, [withTableActions, filteredFields, selectedFields, onFieldSelection, stream.name]);
  const trailingColumns = (0, _react.useMemo)(() => {
    if (!withTableActions) return undefined;
    return [createFieldActionsCellRenderer(filteredFields)];
  }, [withTableActions, filteredFields]);
  const RenderCellValue = (0, _react.useMemo)(() => createCellRenderer(filteredFields, stream), [filteredFields, stream]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDataGrid, {
    "data-test-subj": isLoading ? 'streamsAppSchemaEditorFieldsTableLoading' : 'streamsAppSchemaEditorFieldsTableLoaded',
    "aria-label": _i18n.i18n.translate('xpack.streams.streamDetailSchemaEditor.fieldsTable.actionsTitle', {
      defaultMessage: 'Preview'
    }),
    columns: Object.entries(_constants.TABLE_COLUMNS).map(([columnId, value]) => ({
      id: columnId,
      ...value
    })),
    columnVisibility: {
      visibleColumns,
      setVisibleColumns,
      canDragAndDropColumns: false
    },
    sorting: {
      columns: sortingColumns,
      onSort: setSortingColumns
    },
    toolbarVisibility: withToolbar,
    rowCount: filteredFields.length,
    renderCellValue: RenderCellValue,
    leadingControlColumns: leadingColumns,
    trailingControlColumns: trailingColumns,
    gridStyle: {
      border: 'all',
      rowHover: 'highlight',
      header: 'shade'
    },
    inMemory: {
      level: 'sorting'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 5
    }
  });
}
const createCellRenderer = (fields, stream) => ({
  rowIndex,
  columnId
}) => {
  const field = fields[rowIndex];
  if (!field) return null;
  const {
    parent,
    status
  } = field;
  if (columnId === 'type') {
    // Prioritize showing esType if available and different from our supported type
    if (field.esType && (!field.type || field.type === 'system')) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "center",
        gutterSize: "xs",
        responsive: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 142,
          columnNumber: 11
        }
      }, field.esType, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        content: _i18n.i18n.translate('xpack.streams.streamDetailSchemaEditorFieldsTableTypeEsTypeTooltip', {
          defaultMessage: 'This field is not managed by Streams, but is defined in Elasticsearch. It can also be controlled via the underlying index template and component templates available in the "Advanced" tab.'
        }),
        position: "right",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 144,
          columnNumber: 13
        }
      }));
    }
    if (!field.type) {
      // For fields with undefined type (unmanaged fields), show "dynamic" only for classic streams
      if (field.status === 'unmapped') {
        const streamType = (0, _get_stream_type_from_definition.getStreamTypeFromDefinition)(stream);
        if (streamType === 'classic') {
          return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, '<dynamic>');
        }
        return _constants.EMPTY_CONTENT;
      }
      return _constants.EMPTY_CONTENT;
    }
    return /*#__PURE__*/_react.default.createElement(_field_type.FieldType, {
      type: field.type,
      aliasFor: field.alias_for,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 170,
        columnNumber: 14
      }
    });
  }
  if (columnId === 'parent') {
    return /*#__PURE__*/_react.default.createElement(_field_parent.FieldParent, {
      parent: parent,
      linkEnabled: field.parent !== stream.name,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 174,
        columnNumber: 14
      }
    });
  }
  if (columnId === 'status') {
    const editorField = field;
    const streamType = (0, _get_stream_type_from_definition.getStreamTypeFromDefinition)(stream);
    return /*#__PURE__*/_react.default.createElement(_field_status.FieldStatusBadge, {
      status: status,
      uncommitted: editorField.uncommitted,
      streamType: streamType,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 181,
        columnNumber: 9
      }
    });
  }
  if (columnId === 'result') {
    const editorField = field;
    if (editorField.result) {
      return /*#__PURE__*/_react.default.createElement(_field_result.FieldResultBadge, {
        result: editorField.result,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 192,
          columnNumber: 16
        }
      });
    }
    return _constants.EMPTY_CONTENT;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, field[columnId] || _constants.EMPTY_CONTENT);
};
const createFieldActionsCellRenderer = fields => ({
  id: 'field-actions',
  width: 40,
  headerCellRender: () => /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 204,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('xpack.streams.streamDetailSchemaEditorFieldsTableActionsTitle', {
    defaultMessage: 'Field actions'
  }))),
  rowCellRender: ({
    rowIndex
  }) => {
    const field = fields[rowIndex];
    if (!field) return null;
    return /*#__PURE__*/_react.default.createElement(_field_actions.FieldActionsCell, {
      field: field,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 217,
        columnNumber: 12
      }
    });
  }
});
const createFieldSelectionCellRenderer = (fields, selectedFields, onChange, streamName) => ({
  id: 'field-selection',
  width: 40,
  headerCellRender: () => {
    const selectableFields = fields.filter(field => isSelectableField(streamName, field));
    if (selectableFields.length === 0) {
      return;
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
      id: "selectAllFields",
      onChange: e => {
        onChange(selectableFields.map(field => field.name), e.target.checked);
      },
      checked: selectableFields.every(field => selectedFields.includes(field.name)),
      indeterminate: selectedFields.length > 0 && !selectableFields.every(field => selectedFields.includes(field.name)),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 236,
        columnNumber: 7
      }
    });
  },
  rowCellRender: ({
    rowIndex
  }) => {
    const field = fields[rowIndex];
    if (!isSelectableField(streamName, field)) return null;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
      id: field.name,
      onChange: e => onChange([field.name], e.target.checked),
      checked: selectedFields.includes(field.name),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 258,
        columnNumber: 7
      }
    });
  }
});
const filterFieldsByControls = (fields, controls) => {
  if (!controls.query && (0, _lodash.isEmpty)(controls.type) && (0, _lodash.isEmpty)(controls.status)) {
    return fields;
  }
  const matchingQueryFields = _eui.EuiSearchBar.Query.execute(controls.query, fields, {
    defaultFields: ['name', 'type']
  });
  const filteredByGroupsFields = matchingQueryFields.filter(field => {
    return ((0, _lodash.isEmpty)(controls.type) || field.type && controls.type.includes(field.type)) && (
    // Filter by applied type
    (0, _lodash.isEmpty)(controls.status) || controls.status.includes(field.status)) // Filter by applied status
    ;
  });
  return filteredByGroupsFields;
};
const isSelectableField = (streamName, field) => {
  return field.status !== 'inherited' && field.parent === streamName && !field.alias_for && field.type !== 'system';
};
exports.isSelectableField = isSelectableField;